(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7782,        262]
NotebookOptionsPosition[      5745,        197]
NotebookOutlinePosition[      6846,        227]
CellTagsIndexPosition[      6803,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[OSlash]" :> 
          Documentation`HelpLookup["paclet:ref/character/OSlash"], 
          "\\[EmptySet]" :> 
          Documentation`HelpLookup["paclet:ref/character/EmptySet"], 
          "\\[Diameter]" :> 
          Documentation`HelpLookup["paclet:ref/character/Diameter"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[OSlash]\"\>", 
       2->"\<\"\\\\[EmptySet]\"\>", 
       3->"\<\"\\\\[Diameter]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CapitalOSlash]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CapitalOSlash]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->67200477],

Cell["\\[CapitalOSlash]", "CharacterName",
 CellID->8890],

Cell["Unicode: 00D8.", "Notes",
 CellID->836481],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["O/", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->6640],

Cell["Letter. ", "Notes",
 CellID->28703],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->5566],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[EmptySet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySet"]], "InlineCharacterName"],
 " or ",
 Cell[TextData[ButtonBox["\\[Diameter]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Diameter"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->4883]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->23661],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->22659],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->32765],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[OSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OSlash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptySet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySet"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Diameter]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Diameter"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->19601]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->106069521],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CapitalOSlash] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 35, 47.2714580}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00D8. Alias: Esc O/ Esc. Letter. Included in ISO Latin-1. Not \
the same as \\[EmptySet] or \\[Diameter]. ", 
    "synonyms" -> {"capital o slash"}, "title" -> "\\[CapitalOSlash]", "type" -> 
    "Character Name", "uri" -> "ref/character/CapitalOSlash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2279, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2902, 84, 596, 19, 70, "CharacterImage",
 CellID->67200477],
Cell[3501, 105, 57, 1, 70, "CharacterName",
 CellID->8890],
Cell[3561, 108, 48, 1, 70, "Notes",
 CellID->836481],
Cell[3612, 111, 233, 9, 70, "Notes",
 CellID->6640],
Cell[3848, 122, 41, 1, 70, "Notes",
 CellID->28703],
Cell[3892, 125, 65, 1, 70, "Notes",
 CellID->5566],
Cell[3960, 128, 349, 11, 70, "Notes",
 CellID->4883]
}, Open  ]],
Cell[CellGroupData[{
Cell[4346, 144, 53, 1, 70, "TutorialsSection",
 CellID->23661],
Cell[4402, 147, 180, 5, 70, "Tutorials",
 CellID->22659],
Cell[4585, 154, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4795, 162, 50, 1, 70, "SeeAlsoSection",
 CellID->32765],
Cell[4848, 165, 614, 17, 70, "SeeAlso",
 CellID->19601]
}, Open  ]],
Cell[CellGroupData[{
Cell[5499, 187, 58, 1, 70, "MoreAboutSection",
 CellID->106069521],
Cell[5560, 190, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5718, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

