(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7634,        263]
NotebookOptionsPosition[      5592,        198]
NotebookOutlinePosition[      6693,        228]
CellTagsIndexPosition[      6650,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Pi]" :> Documentation`HelpLookup["paclet:ref/character/Pi"],
           "\\[Product]" :> 
          Documentation`HelpLookup["paclet:ref/character/Product"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Pi]\"\>", 
       2->"\<\"\\\\[Product]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CapitalPi]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CapitalPi]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->66089003],

Cell["\\[CapitalPi]", "CharacterName",
 CellID->23967],

Cell["Unicode: 03A0.", "Notes",
 CellID->10816],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["P", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Pi", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->11393],

Cell["Greek letter. ", "Notes",
 CellID->16704],

Cell[TextData[{
 "Used in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29866],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Product]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Product"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->30953]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30308],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->28223],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10048],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Pi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Pi"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Product]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Product"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->32469]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->162742512],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CapitalPi] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 35, 54.3185134}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03A0. Aliases: Esc P Esc, Esc Pi Esc. Greek letter. Used in \
TraditionalForm for EllipticPi. Not the same as \\[Product]. ", 
    "synonyms" -> {"capital pi"}, "title" -> "\\[CapitalPi]", "type" -> 
    "Character Name", "uri" -> "ref/character/CapitalPi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2087, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2710, 79, 588, 19, 70, "CharacterImage",
 CellID->66089003],
Cell[3301, 100, 54, 1, 70, "CharacterName",
 CellID->23967],
Cell[3358, 103, 47, 1, 70, "Notes",
 CellID->10816],
Cell[3408, 106, 415, 15, 70, "Notes",
 CellID->11393],
Cell[3826, 123, 47, 1, 70, "Notes",
 CellID->16704],
Cell[3876, 126, 329, 13, 70, "Notes",
 CellID->29866],
Cell[4208, 141, 204, 7, 70, "Notes",
 CellID->30953]
}, Open  ]],
Cell[CellGroupData[{
Cell[4449, 153, 53, 1, 70, "TutorialsSection",
 CellID->30308],
Cell[4505, 156, 153, 3, 70, "Tutorials",
 CellID->28223],
Cell[4661, 161, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4871, 169, 50, 1, 70, "SeeAlsoSection",
 CellID->10048],
Cell[4924, 172, 385, 11, 70, "SeeAlso",
 CellID->32469]
}, Open  ]],
Cell[CellGroupData[{
Cell[5346, 188, 58, 1, 70, "MoreAboutSection",
 CellID->162742512],
Cell[5407, 191, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5565, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

