(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7568,        255]
NotebookOptionsPosition[      5462,        189]
NotebookOutlinePosition[      6633,        220]
CellTagsIndexPosition[      6590,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CurlyCapitalUpsilon]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/CurlyCapitalUpsilon"], "\\[Upsilon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Upsilon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[CurlyCapitalUpsilon]\"\>", 
       2->"\<\"\\\\[Upsilon]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CapitalUpsilon]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CapitalUpsilon]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->789881584],

Cell["\\[CapitalUpsilon]", "CharacterName",
 CellID->31245],

Cell["Unicode: 03A5.", "Notes",
 CellID->32764],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["U", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Upsilon", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->6238],

Cell["Greek letter. ", "Notes",
 CellID->27671],

Cell["Not commonly used. ", "Notes",
 CellID->2047],

Cell[TextData[{
 "Used in physics for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", 
    OverscriptBox["b", "_"]}], TraditionalForm]], "InlineMath"],
 " particles, and in the quantum theory of measurement. "
}], "Notes",
 CellID->26115]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4592],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->27311],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7171],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CurlyCapitalUpsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyCapitalUpsilon"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Upsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Upsilon"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20580]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->41284145],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CapitalUpsilon] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 2.9593596}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03A5. Aliases: Esc U Esc, Esc Upsilon Esc. Greek letter. Not \
commonly used. Used in physics for bOverscriptBox[b, _] particles, and in the \
quantum theory of measurement. ", "synonyms" -> {"capital upsilon"}, "title" -> 
    "\\[CapitalUpsilon]", "type" -> "Character Name", "uri" -> 
    "ref/character/CapitalUpsilon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2150, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2773, 80, 599, 19, 70, "CharacterImage",
 CellID->789881584],
Cell[3375, 101, 59, 1, 70, "CharacterName",
 CellID->31245],
Cell[3437, 104, 47, 1, 70, "Notes",
 CellID->32764],
Cell[3487, 107, 419, 15, 70, "Notes",
 CellID->6238],
Cell[3909, 124, 47, 1, 70, "Notes",
 CellID->27671],
Cell[3959, 127, 51, 1, 70, "Notes",
 CellID->2047],
Cell[4013, 130, 235, 8, 70, "Notes",
 CellID->26115]
}, Open  ]],
Cell[CellGroupData[{
Cell[4285, 143, 52, 1, 70, "TutorialsSection",
 CellID->4592],
Cell[4340, 146, 153, 3, 70, "Tutorials",
 CellID->27311],
Cell[4496, 151, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4706, 159, 49, 1, 70, "SeeAlsoSection",
 CellID->7171],
Cell[4758, 162, 422, 12, 70, "SeeAlso",
 CellID->20580]
}, Open  ]],
Cell[CellGroupData[{
Cell[5217, 179, 57, 1, 70, "MoreAboutSection",
 CellID->41284145],
Cell[5277, 182, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5435, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

