(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8427,        288]
NotebookOptionsPosition[      6070,        216]
NotebookOutlinePosition[      7381,        249]
CellTagsIndexPosition[      7338,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CenterEllipsis]" :> 
          Documentation`HelpLookup["paclet:ref/character/CenterEllipsis"], 
          "\\[RawDot]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawDot"], 
          "\\[CircleDot]" :> 
          Documentation`HelpLookup["paclet:ref/character/CircleDot"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[CenterEllipsis]\"\>", 
       2->"\<\"\\\\[RawDot]\"\>", 
       3->"\<\"\\\\[CircleDot]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CenterDot]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CenterDot]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->23608197],

Cell["\\[CenterDot]", "CharacterName",
 CellID->27577],

Cell["Unicode: 00B7.", "Notes",
 CellID->45052876],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox[".", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3402],

Cell["Infix operator. ", "Notes",
 CellID->23115],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[CenterDot]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CenterDot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CenterDot"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23292],

Cell["\<\
Used to indicate various forms of multiplication, particularly dot products \
of vectors. \
\>", "Notes",
 CellID->1723],

Cell["Sometimes used to indicate concatenation or composition. ", "Notes",
 CellID->2872],

Cell["\<\
Used in the British mathematical tradition as a decimal point. \
\>", "Notes",
 CellID->29448]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30323],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->11153],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->15948]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4508],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CenterEllipsis]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CenterEllipsis"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawDot"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CircleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleDot"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->22908]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->256461406],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CenterDot] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 10.7720596}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00B7. Alias: Esc . Esc. Infix operator. x \\[CenterDot] y is by \
default interpreted as CenterDot[x,y]. Used to indicate various forms of \
multiplication, particularly dot products of vectors. Sometimes used to \
indicate concatenation or composition. Used in the British mathematical \
tradition as a decimal point. ", "synonyms" -> {"center dot", "interpunct"}, 
    "title" -> "\\[CenterDot]", "type" -> "Character Name", "uri" -> 
    "ref/character/CenterDot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2215, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2838, 82, 588, 19, 70, "CharacterImage",
 CellID->23608197],
Cell[3429, 103, 54, 1, 70, "CharacterName",
 CellID->27577],
Cell[3486, 106, 50, 1, 70, "Notes",
 CellID->45052876],
Cell[3539, 109, 232, 9, 70, "Notes",
 CellID->3402],
Cell[3774, 120, 49, 1, 70, "Notes",
 CellID->23115],
Cell[3826, 123, 504, 20, 70, "Notes",
 CellID->23292],
Cell[4333, 145, 130, 4, 70, "Notes",
 CellID->1723],
Cell[4466, 151, 89, 1, 70, "Notes",
 CellID->2872],
Cell[4558, 154, 104, 3, 70, "Notes",
 CellID->29448]
}, Open  ]],
Cell[CellGroupData[{
Cell[4699, 162, 53, 1, 70, "TutorialsSection",
 CellID->30323],
Cell[4755, 165, 180, 5, 70, "Tutorials",
 CellID->11153],
Cell[4938, 172, 129, 3, 70, "Tutorials",
 CellID->15948]
}, Open  ]],
Cell[CellGroupData[{
Cell[5104, 180, 49, 1, 70, "SeeAlsoSection",
 CellID->4508],
Cell[5156, 183, 631, 18, 70, "SeeAlso",
 CellID->22908]
}, Open  ]],
Cell[CellGroupData[{
Cell[5824, 206, 58, 1, 70, "MoreAboutSection",
 CellID->256461406],
Cell[5885, 209, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6043, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

