(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8188,        278]
NotebookOptionsPosition[      5945,        209]
NotebookOutlinePosition[      7201,        241]
CellTagsIndexPosition[      7158,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CircleTimes]" :> 
          Documentation`HelpLookup["paclet:ref/character/CircleTimes"], 
          "\\[CircleMinus]" :> 
          Documentation`HelpLookup["paclet:ref/character/CircleMinus"], 
          "\\[Xor]" :> 
          Documentation`HelpLookup["paclet:ref/character/Xor"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[CircleTimes]\"\>", 
       2->"\<\"\\\\[CircleMinus]\"\>", 
       3->"\<\"\\\\[Xor]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CirclePlus]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CirclePlus]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->55229173],

Cell["\\[CirclePlus]", "CharacterName",
 CellID->5695],

Cell["Unicode: 2295.", "Notes",
 CellID->12503],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["c+", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->5032],

Cell["Infix operator. ", "Notes",
 CellID->13851],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CirclePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CirclePlus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1537],

Cell["\<\
Used in mathematics for various operations related to addition, such as \
direct sum and addition modulo two. \
\>", "Notes",
 CellID->26814],

Cell["\<\
Also sometimes used to indicate a vector pointing into the page. \
\>", "Notes",
 CellID->8363]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4651],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->1219],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->24290]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31918],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CircleTimes]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleTimes"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CircleMinus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleMinus"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Xor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Xor"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->26584]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->19803841],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CirclePlus] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 18.6316358}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2295. Alias: Esc c+ Esc. Infix operator. x (+) y is by default \
interpreted as CirclePlus[x,y]. Used in mathematics for various operations \
related to addition, such as direct sum and addition modulo two. Also \
sometimes used to indicate a vector pointing into the page. ", 
    "synonyms" -> {"circle plus"}, "title" -> "\\[CirclePlus]", "type" -> 
    "Character Name", "uri" -> "ref/character/CirclePlus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2188, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2811, 81, 590, 19, 70, "CharacterImage",
 CellID->55229173],
Cell[3404, 102, 54, 1, 70, "CharacterName",
 CellID->5695],
Cell[3461, 105, 47, 1, 70, "Notes",
 CellID->12503],
Cell[3511, 108, 233, 9, 70, "Notes",
 CellID->5032],
Cell[3747, 119, 49, 1, 70, "Notes",
 CellID->13851],
Cell[3799, 122, 506, 20, 70, "Notes",
 CellID->1537],
Cell[4308, 144, 151, 4, 70, "Notes",
 CellID->26814],
Cell[4462, 150, 105, 3, 70, "Notes",
 CellID->8363]
}, Open  ]],
Cell[CellGroupData[{
Cell[4604, 158, 52, 1, 70, "TutorialsSection",
 CellID->4651],
Cell[4659, 161, 162, 3, 70, "Tutorials",
 CellID->1219],
Cell[4824, 166, 129, 3, 70, "Tutorials",
 CellID->24290]
}, Open  ]],
Cell[CellGroupData[{
Cell[4990, 174, 50, 1, 70, "SeeAlsoSection",
 CellID->31918],
Cell[5043, 177, 620, 17, 70, "SeeAlso",
 CellID->26584]
}, Open  ]],
Cell[CellGroupData[{
Cell[5700, 199, 57, 1, 70, "MoreAboutSection",
 CellID->19803841],
Cell[5760, 202, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5918, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

