(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9059,        295]
NotebookOptionsPosition[      6913,        228]
NotebookOutlinePosition[      8076,        259]
CellTagsIndexPosition[      8033,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotCongruent]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotCongruent"], 
          "\\[Equal]" :> 
          Documentation`HelpLookup["paclet:ref/character/Equal"], 
          "\\[TildeFullEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/TildeFullEqual"], 
          "\\[CupCap]" :> 
          Documentation`HelpLookup["paclet:ref/character/CupCap"], 
          "\\[LeftRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftRightArrow"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[NotCongruent]\"\>", 
       2->"\<\"\\\\[Equal]\"\>", 3->"\<\"\\\\[TildeFullEqual]\"\>", 
       4->"\<\"\\\\[CupCap]\"\>", 
       5->"\<\"\\\\[LeftRightArrow]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Congruent]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Congruent]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->59758886],

Cell["\\[Congruent]", "CharacterName",
 CellID->27732],

Cell["Unicode: 2261.", "Notes",
 CellID->12437],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["===", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->11684],

Cell["Infix similarity operator. ", "Notes",
 CellID->32499],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Congruent]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Congruent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Congruent"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32701],

Cell["\<\
Used in mathematics for many notions of equivalence and equality. \
\>", "Notes",
 CellID->29869]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->28583],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->29256],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->19692]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->15012],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotCongruent]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotCongruent"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Equal]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[TildeFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/TildeFullEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CupCap]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CupCap"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftRightArrow"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->13810]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->335023747],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Congruent] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 26.4599612}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2261. Alias: Esc === Esc. Infix similarity operator. x \
\\[Congruent] y is by default interpreted as Congruent[x,y]. Used in \
mathematics for many notions of equivalence and equality. ", 
    "synonyms" -> {"congruent"}, "title" -> "\\[Congruent]", "type" -> 
    "Character Name", "uri" -> "ref/character/Congruent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2675, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3298, 89, 588, 19, 70, "CharacterImage",
 CellID->59758886],
Cell[3889, 110, 54, 1, 70, "CharacterName",
 CellID->27732],
Cell[3946, 113, 47, 1, 70, "Notes",
 CellID->12437],
Cell[3996, 116, 235, 9, 70, "Notes",
 CellID->11684],
Cell[4234, 127, 60, 1, 70, "Notes",
 CellID->32499],
Cell[4297, 130, 504, 20, 70, "Notes",
 CellID->32701],
Cell[4804, 152, 107, 3, 70, "Notes",
 CellID->29869]
}, Open  ]],
Cell[CellGroupData[{
Cell[4948, 160, 53, 1, 70, "TutorialsSection",
 CellID->28583],
Cell[5004, 163, 163, 3, 70, "Tutorials",
 CellID->29256],
Cell[5170, 168, 129, 3, 70, "Tutorials",
 CellID->19692]
}, Open  ]],
Cell[CellGroupData[{
Cell[5336, 176, 50, 1, 70, "SeeAlsoSection",
 CellID->15012],
Cell[5389, 179, 1081, 30, 70, "SeeAlso",
 CellID->13810]
}, Open  ]],
Cell[CellGroupData[{
Cell[6507, 214, 58, 1, 70, "MoreAboutSection",
 CellID->335023747],
Cell[6568, 217, 143, 2, 70, "MoreAbout"],
Cell[6714, 221, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6886, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

