(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7857,        270]
NotebookOptionsPosition[      5735,        204]
NotebookOutlinePosition[      6917,        235]
CellTagsIndexPosition[      6874,        232]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ConjugateTranspose]" :> 
          Documentation`HelpLookup["paclet:ref/character/ConjugateTranspose"],
           "\\[HermitianConjugate]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/HermitianConjugate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[ConjugateTranspose]\"\>", 
       2->"\<\"\\\\[HermitianConjugate]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Conjugate]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Conjugate]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->272554724],

Cell["\\[Conjugate]", "CharacterName",
 CellID->28822],

Cell["Unicode: F3C8.", "Notes",
 CellID->4055],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["co", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["conj", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->18913],

Cell["\<\
Superscript postfix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->462],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["z", "TI"], "\[Conjugate]"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24473],

Cell[TextData[{
 "Not the same as keyboard ",
 Cell[BoxData["*"], "InlineFormula"],
 " or ",
 Cell[TextData[ButtonBox["\\[Star]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Star"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->20084]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->31122],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->26053],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->19397]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21337],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ConjugateTranspose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ConjugateTranspose"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[HermitianConjugate]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HermitianConjugate"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->13917]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->560881328],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Conjugate] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 26.6162152}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3C8. Aliases: Esc co Esc, Esc conj Esc. Superscript postfix \
operator with built-in evaluation rules. z^\\[Conjugate] is by default \
interpreted as Conjugate[z]. Not the same as keyboard * or \\[Star]. ", 
    "synonyms" -> {"conjugate"}, "title" -> "\\[Conjugate]", "type" -> 
    "Character Name", "uri" -> "ref/character/Conjugate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2091, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2714, 79, 589, 19, 70, "CharacterImage",
 CellID->272554724],
Cell[3306, 100, 54, 1, 70, "CharacterName",
 CellID->28822],
Cell[3363, 103, 46, 1, 70, "Notes",
 CellID->4055],
Cell[3412, 106, 418, 15, 70, "Notes",
 CellID->18913],
Cell[3833, 123, 108, 3, 70, "Notes",
 CellID->462],
Cell[3944, 128, 347, 13, 70, "Notes",
 CellID->24473],
Cell[4294, 143, 254, 9, 70, "Notes",
 CellID->20084]
}, Open  ]],
Cell[CellGroupData[{
Cell[4585, 157, 53, 1, 70, "TutorialsSection",
 CellID->31122],
Cell[4641, 160, 144, 3, 70, "Tutorials",
 CellID->26053],
Cell[4788, 165, 129, 3, 70, "Tutorials",
 CellID->19397]
}, Open  ]],
Cell[CellGroupData[{
Cell[4954, 173, 50, 1, 70, "SeeAlsoSection",
 CellID->21337],
Cell[5007, 176, 445, 13, 70, "SeeAlso",
 CellID->13917]
}, Open  ]],
Cell[CellGroupData[{
Cell[5489, 194, 58, 1, 70, "MoreAboutSection",
 CellID->560881328],
Cell[5550, 197, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5708, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

