(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8129,        269]
NotebookOptionsPosition[      5975,        203]
NotebookOutlinePosition[      7217,        235]
CellTagsIndexPosition[      7174,        232]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawBackslash]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawBackslash"], 
          "\\[Backslash]" :> 
          Documentation`HelpLookup["paclet:ref/character/Backslash"], 
          "\\[ReturnIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnIndicator"], 
          "\\[DescendingEllipsis]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/DescendingEllipsis"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[RawBackslash]\"\>", 
       2->"\<\"\\\\[Backslash]\"\>", 3->"\<\"\\\\[ReturnIndicator]\"\>", 
       4->"\<\"\\\\[DescendingEllipsis]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Continuation]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Continuation]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->238422884],

Cell["\\[Continuation]", "CharacterName",
 CellID->20666],

Cell["Unicode: F3B1.", "Notes",
 CellID->1344],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cont", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32736],

Cell["Structural element. ", "Notes",
 CellID->22037],

Cell["\<\
Used at the end of a line of input to indicate that the expression on that \
line continues onto the next line. \
\>", "Notes",
 CellID->5416],

Cell["\<\
Equivalent in meaning to \[Backslash] at the end of a line. \
\>", "Notes",
 CellID->5893],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[DescendingEllipsis]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DescendingEllipsis"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->1949]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30971],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->10844]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->26200],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawBackslash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawBackslash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Backslash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Backslash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReturnIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DescendingEllipsis]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DescendingEllipsis"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->14590]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Continuation] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 27.0537264}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3B1. Alias: Esc cont Esc. Structural element. Used at the end \
of a line of input to indicate that the expression on that line continues \
onto the next line. Equivalent in meaning to \\ at the end of a line. Not the \
same as \\[DescendingEllipsis]. ", "synonyms" -> {"continuation"}, "title" -> 
    "\\[Continuation]", "type" -> "Character Name", "uri" -> 
    "ref/character/Continuation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2335, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2958, 84, 595, 19, 70, "CharacterImage",
 CellID->238422884],
Cell[3556, 105, 57, 1, 70, "CharacterName",
 CellID->20666],
Cell[3616, 108, 46, 1, 70, "Notes",
 CellID->1344],
Cell[3665, 111, 236, 9, 70, "Notes",
 CellID->32736],
Cell[3904, 122, 53, 1, 70, "Notes",
 CellID->22037],
Cell[3960, 125, 152, 4, 70, "Notes",
 CellID->5416],
Cell[4115, 131, 100, 3, 70, "Notes",
 CellID->5893],
Cell[4218, 136, 228, 8, 70, "Notes",
 CellID->1949]
}, Open  ]],
Cell[CellGroupData[{
Cell[4483, 149, 53, 1, 70, "TutorialsSection",
 CellID->30971],
Cell[4539, 152, 196, 4, 70, "Tutorials",
 CellID->10844]
}, Open  ]],
Cell[CellGroupData[{
Cell[4772, 161, 38, 0, 70, "MoreAboutSection"],
Cell[4813, 163, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4993, 170, 50, 1, 70, "SeeAlsoSection",
 CellID->26200],
Cell[5046, 173, 887, 25, 70, "SeeAlso",
 CellID->14590]
}, Open  ]],
Cell[5948, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

