(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7442,        248]
NotebookOptionsPosition[      5544,        187]
NotebookOutlinePosition[      6619,        217]
CellTagsIndexPosition[      6576,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftModified]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftModified"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"], 
          "\\[EscapeKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/EscapeKey"], 
          "\\[ReturnKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnKey"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftModified]\"\>", 
       2->"\<\"\\\\[CommandKey]\"\>", 3->"\<\"\\\\[EscapeKey]\"\>", 
       4->"\<\"\\\\[ReturnKey]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ControlKey]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ControlKey]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->583201725],

Cell["\\[ControlKey]", "CharacterName",
 CellID->8239],

Cell["Unicode: F763.", "Notes",
 CellID->3426],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ctrl", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->19095],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->30906],

Cell[TextData[{
 "Representation of the ",
 StyleBox["Ctrl", "KeyEvent"],
 " key on a keyboard. "
}], "Notes",
 CellID->8314]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->10350],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->4586]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25822],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftModified"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EscapeKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EscapeKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReturnKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnKey"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->6879]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->704215919],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ControlKey] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 27.3193582}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F763. Alias: Esc ctrl Esc. Letter-like form. Representation of \
the Ctrl key on a keyboard. ", "synonyms" -> {"control key"}, "title" -> 
    "\\[ControlKey]", "type" -> "Character Name", "uri" -> 
    "ref/character/ControlKey"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2282, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2905, 83, 591, 19, 70, "CharacterImage",
 CellID->583201725],
Cell[3499, 104, 54, 1, 70, "CharacterName",
 CellID->8239],
Cell[3556, 107, 46, 1, 70, "Notes",
 CellID->3426],
Cell[3605, 110, 236, 9, 70, "Notes",
 CellID->19095],
Cell[3844, 121, 59, 1, 70, "Notes",
 CellID->30906],
Cell[3906, 124, 125, 5, 70, "Notes",
 CellID->8314]
}, Open  ]],
Cell[CellGroupData[{
Cell[4068, 134, 53, 1, 70, "TutorialsSection",
 CellID->10350],
Cell[4124, 137, 195, 4, 70, "Tutorials",
 CellID->4586]
}, Open  ]],
Cell[CellGroupData[{
Cell[4356, 146, 50, 1, 70, "SeeAlsoSection",
 CellID->25822],
Cell[4409, 149, 852, 23, 70, "SeeAlso",
 CellID->6879]
}, Open  ]],
Cell[CellGroupData[{
Cell[5298, 177, 58, 1, 70, "MoreAboutSection",
 CellID->704215919],
Cell[5359, 180, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5517, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

