(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8782,        304]
NotebookOptionsPosition[      6430,        231]
NotebookOutlinePosition[      7681,        263]
CellTagsIndexPosition[      7638,        260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CircleTimes]" :> 
          Documentation`HelpLookup["paclet:ref/character/CircleTimes"], 
          "\\[Times]" :> 
          Documentation`HelpLookup["paclet:ref/character/Times"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[CircleTimes]\"\>", 
       2->"\<\"\\\\[Times]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Cross]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Cross]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->86256978],

Cell["\\[Cross]", "CharacterName",
 CellID->8144],

Cell["Unicode: F4A0.", "Notes",
 CellID->32240],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cross", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->29334],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->15296],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Cross]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11876],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->25027],

Cell[TextData[{
 Cell["\\[Cross]", "InlineCharacterName"],
 " represents vector cross product, while ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " represents ordinary multiplication. "
}], "Notes",
 CellID->1205],

Cell[TextData[{
 Cell["\\[Cross]", "InlineCharacterName"],
 " is drawn smaller than ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->2018]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4291],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->31641],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->13465],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->16191]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23700],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CircleTimes]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleTimes"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20217]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->36827778],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Cross] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 34.4757914}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F4A0. Alias: Esc cross Esc. Infix operator with built-in \
evaluation rules. x x y is by default interpreted as Cross[x,y]. Not the same \
as \\[Times]. \\[Cross] represents vector cross product, while \\[Times] \
represents ordinary multiplication. \\[Cross] is drawn smaller than \
\\[Times]. ", "synonyms" -> {"cross"}, "title" -> "\\[Cross]", "type" -> 
    "Character Name", "uri" -> "ref/character/Cross"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2210, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2833, 82, 580, 19, 70, "CharacterImage",
 CellID->86256978],
Cell[3416, 103, 49, 1, 70, "CharacterName",
 CellID->8144],
Cell[3468, 106, 47, 1, 70, "Notes",
 CellID->32240],
Cell[3518, 109, 237, 9, 70, "Notes",
 CellID->29334],
Cell[3758, 120, 96, 3, 70, "Notes",
 CellID->15296],
Cell[3857, 125, 492, 20, 70, "Notes",
 CellID->11876],
Cell[4352, 147, 200, 7, 70, "Notes",
 CellID->25027],
Cell[4555, 156, 301, 8, 70, "Notes",
 CellID->1205],
Cell[4859, 166, 249, 8, 70, "Notes",
 CellID->2018]
}, Open  ]],
Cell[CellGroupData[{
Cell[5145, 179, 52, 1, 70, "TutorialsSection",
 CellID->4291],
Cell[5200, 182, 144, 3, 70, "Tutorials",
 CellID->31641],
Cell[5347, 187, 180, 5, 70, "Tutorials",
 CellID->13465],
Cell[5530, 194, 129, 3, 70, "Tutorials",
 CellID->16191]
}, Open  ]],
Cell[CellGroupData[{
Cell[5696, 202, 50, 1, 70, "SeeAlsoSection",
 CellID->23700],
Cell[5749, 205, 399, 11, 70, "SeeAlso",
 CellID->20217]
}, Open  ]],
Cell[CellGroupData[{
Cell[6185, 221, 57, 1, 70, "MoreAboutSection",
 CellID->36827778],
Cell[6245, 224, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6403, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

