(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7602,        257]
NotebookOptionsPosition[      5552,        192]
NotebookOutlinePosition[      6634,        222]
CellTagsIndexPosition[      6591,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Phi]" :> 
          Documentation`HelpLookup["paclet:ref/character/Phi"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Phi]\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Greek Letters" :> 
          Documentation`HelpLookup["paclet:guide/GreekLetters"], 
          "Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Greek Letters\"\>", 
       2->"\<\"Listing of Named Characters\"\>", 
       3->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CurlyPhi]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CurlyPhi]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->229717993],

Cell["\\[CurlyPhi]", "CharacterName",
 CellID->17774],

Cell["Unicode: 03C6.", "Notes",
 CellID->2884],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["j", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cph", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cphi", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->20128],

Cell["Greek letter. ", "Notes",
 CellID->24546],

Cell[TextData[{
 "Commonly used as a variant of ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3145]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20481],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->11714],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20307],

Cell[TextData[Cell[TextData[ButtonBox["\\[Phi]",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/character/Phi"]], "InlineCharacterName"]], "SeeAlso",\

 CellID->26793]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->359166093],

Cell[TextData[ButtonBox["Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GreekLetters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CurlyPhi] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 35.3664392}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03C6. Aliases: Esc j Esc, Esc cph Esc, Esc cphi Esc. Greek \
letter. Commonly used as a variant of \\[Phi]. ", "synonyms" -> {"curly phi"},
     "title" -> "\\[CurlyPhi]", "type" -> "Character Name", "uri" -> 
    "ref/character/CurlyPhi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2226, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2849, 82, 587, 19, 70, "CharacterImage",
 CellID->229717993],
Cell[3439, 103, 53, 1, 70, "CharacterName",
 CellID->17774],
Cell[3495, 106, 46, 1, 70, "Notes",
 CellID->2884],
Cell[3544, 109, 598, 21, 70, "Notes",
 CellID->20128],
Cell[4145, 132, 47, 1, 70, "Notes",
 CellID->24546],
Cell[4195, 135, 153, 6, 70, "Notes",
 CellID->3145]
}, Open  ]],
Cell[CellGroupData[{
Cell[4385, 146, 53, 1, 70, "TutorialsSection",
 CellID->20481],
Cell[4441, 149, 153, 3, 70, "Tutorials",
 CellID->11714],
Cell[4597, 154, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4807, 162, 50, 1, 70, "SeeAlsoSection",
 CellID->20307],
Cell[4860, 165, 165, 4, 70, "SeeAlso",
 CellID->26793]
}, Open  ]],
Cell[CellGroupData[{
Cell[5062, 174, 58, 1, 70, "MoreAboutSection",
 CellID->359166093],
Cell[5123, 177, 117, 2, 70, "MoreAbout"],
Cell[5243, 181, 143, 2, 70, "MoreAbout"],
Cell[5389, 185, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5525, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

