(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9057,        304]
NotebookOptionsPosition[      6751,        233]
NotebookOutlinePosition[      8011,        265]
CellTagsIndexPosition[      7968,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Prime]" :> 
          Documentation`HelpLookup["paclet:ref/character/Prime"], 
          "\\[DoublePrime]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoublePrime"], 
          "\\[SmallCircle]" :> 
          Documentation`HelpLookup["paclet:ref/character/SmallCircle"], 
          "\\[EmptySmallCircle]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/EmptySmallCircle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[Prime]\"\>", 2->"\<\"\\\\[DoublePrime]\"\>",
        3->"\<\"\\\\[SmallCircle]\"\>", 
       4->"\<\"\\\\[EmptySmallCircle]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Degree]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Degree]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->112371387],

Cell["\\[Degree]", "CharacterName",
 CellID->18012],

Cell["Unicode: 00B0.", "Notes",
 CellID->2439366],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["deg", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3338],

Cell["\<\
Letter\[Hyphen]like form with built\[Hyphen]in value. \
\>", "Notes",
 CellID->8706],

Cell[TextData[{
 "Interpreted by default as the symbol ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12525],

Cell[TextData[{
 Cell[BoxData["30"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{"30", "Degree"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30630],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData[
  FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
 " is sometimes used in mathematics to indicate the interior of a set. "
}], "Notes",
 CellID->29249],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[SmallCircle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SmallCircle"]], "InlineCharacterName"],
 " or ",
 Cell[TextData[ButtonBox["\\[EmptySmallCircle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySmallCircle"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->23179]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3079],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->8313],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->14145],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Prime]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Prime"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoublePrime]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoublePrime"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SmallCircle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SmallCircle"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptySmallCircle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySmallCircle"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->5991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->742199585],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Degree] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 43.0541360}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00B0. Alias: Esc deg Esc. Letter-like form with built-in value. \
Interpreted by default as the symbol Degree. 30Degree is interpreted as \
30Degree. The symbol Degree is sometimes used in mathematics to indicate the \
interior of a set. Not the same as \\[SmallCircle] or \\[EmptySmallCircle]. ",
     "synonyms" -> {"degree"}, "title" -> "\\[Degree]", "type" -> 
    "Character Name", "uri" -> "ref/character/Degree"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2414, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3037, 86, 583, 19, 70, "CharacterImage",
 CellID->112371387],
Cell[3623, 107, 51, 1, 70, "CharacterName",
 CellID->18012],
Cell[3677, 110, 49, 1, 70, "Notes",
 CellID->2439366],
Cell[3729, 113, 234, 9, 70, "Notes",
 CellID->3338],
Cell[3966, 124, 94, 3, 70, "Notes",
 CellID->8706],
Cell[4063, 129, 207, 8, 70, "Notes",
 CellID->12525],
Cell[4273, 139, 247, 9, 70, "Notes",
 CellID->30630],
Cell[4523, 150, 205, 6, 70, "Notes",
 CellID->29249],
Cell[4731, 158, 375, 12, 70, "Notes",
 CellID->23179]
}, Open  ]],
Cell[CellGroupData[{
Cell[5143, 175, 52, 1, 70, "TutorialsSection",
 CellID->3079],
Cell[5198, 178, 143, 3, 70, "Tutorials",
 CellID->8313],
Cell[5344, 183, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[5554, 191, 50, 1, 70, "SeeAlsoSection",
 CellID->14145],
Cell[5607, 194, 861, 24, 70, "SeeAlso",
 CellID->5991]
}, Open  ]],
Cell[CellGroupData[{
Cell[6505, 223, 58, 1, 70, "MoreAboutSection",
 CellID->742199585],
Cell[6566, 226, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6724, 231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

