(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8965,        295]
NotebookOptionsPosition[      6787,        227]
NotebookOutlinePosition[      7973,        258]
CellTagsIndexPosition[      7930,        255]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ReverseEquilibrium]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReverseEquilibrium"],
           "\\[RightArrowLeftArrow]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RightArrowLeftArrow"], "\\[LeftRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftRightArrow"], 
          "\\[LeftRightVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftRightVector"], 
          "\\[UpEquilibrium]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpEquilibrium"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[ReverseEquilibrium]\"\>", 
       2->"\<\"\\\\[RightArrowLeftArrow]\"\>", 
       3->"\<\"\\\\[LeftRightArrow]\"\>", 4->"\<\"\\\\[LeftRightVector]\"\>", 
       5->"\<\"\\\\[UpEquilibrium]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Equilibrium]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Equilibrium]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->769200632],

Cell["\\[Equilibrium]", "CharacterName",
 CellID->13345],

Cell["Unicode: 21CC.", "Notes",
 CellID->31443],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["equi", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9850],

Cell["Infix arrow\[Hyphen]like operator. ", "Notes",
 CellID->22593],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Equilibrium]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Equilibrium",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equilibrium"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18664],

Cell["Used in chemistry to represent a reversible reaction. ", "Notes",
 CellID->14442],

Cell["Extensible character. ", "Notes",
 CellID->27444]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->15833],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->30736],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->6502]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17953],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ReverseEquilibrium]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReverseEquilibrium"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightArrowLeftArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrowLeftArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftRightVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftRightVector"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UpEquilibrium]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpEquilibrium"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->11007]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->470561024],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Equilibrium] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 35.3382604}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 21CC. Alias: Esc equi Esc. Infix arrow-like operator. x \
\\[Equilibrium] y is by default interpreted as Equilibrium[x,y]. Used in \
chemistry to represent a reversible reaction. Extensible character. ", 
    "synonyms" -> {"equilibrium"}, "title" -> "\\[Equilibrium]", "type" -> 
    "Character Name", "uri" -> "ref/character/Equilibrium"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2586, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3209, 88, 593, 19, 70, "CharacterImage",
 CellID->769200632],
Cell[3805, 109, 56, 1, 70, "CharacterName",
 CellID->13345],
Cell[3864, 112, 47, 1, 70, "Notes",
 CellID->31443],
Cell[3914, 115, 235, 9, 70, "Notes",
 CellID->9850],
Cell[4152, 126, 68, 1, 70, "Notes",
 CellID->22593],
Cell[4223, 129, 510, 20, 70, "Notes",
 CellID->18664],
Cell[4736, 151, 87, 1, 70, "Notes",
 CellID->14442],
Cell[4826, 154, 55, 1, 70, "Notes",
 CellID->27444]
}, Open  ]],
Cell[CellGroupData[{
Cell[4918, 160, 53, 1, 70, "TutorialsSection",
 CellID->15833],
Cell[4974, 163, 163, 3, 70, "Tutorials",
 CellID->30736],
Cell[5140, 168, 128, 3, 70, "Tutorials",
 CellID->6502]
}, Open  ]],
Cell[CellGroupData[{
Cell[5305, 176, 50, 1, 70, "SeeAlsoSection",
 CellID->17953],
Cell[5358, 179, 1146, 33, 70, "SeeAlso",
 CellID->11007]
}, Open  ]],
Cell[CellGroupData[{
Cell[6541, 217, 58, 1, 70, "MoreAboutSection",
 CellID->470561024],
Cell[6602, 220, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6760, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

