(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7911,        267]
NotebookOptionsPosition[      5950,        204]
NotebookOutlinePosition[      7027,        234]
CellTagsIndexPosition[      6984,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[DoubledGamma]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubledGamma"], 
          "\\[CapitalGamma]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalGamma"], 
          "\\[Digamma]" :> 
          Documentation`HelpLookup["paclet:ref/character/Digamma"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[DoubledGamma]\"\>", 
       2->"\<\"\\\\[CapitalGamma]\"\>", 
       3->"\<\"\\\\[Digamma]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Gamma]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Gamma]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->307501187],

Cell["\\[Gamma]", "CharacterName",
 CellID->17327],

Cell["Unicode: 03B3.", "Notes",
 CellID->28441],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["g", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["gamma", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9053],

Cell["Greek letter. ", "Notes",
 CellID->3323],

Cell[TextData[{
 "Used in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32528]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->5491],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->24597],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->13310],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[DoubledGamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubledGamma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalGamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalGamma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Digamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Digamma"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->3671]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->105511482],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Gamma] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 58.9951160}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03B3. Aliases: Esc g Esc, Esc gamma Esc. Greek letter. Used in \
TraditionalForm for EulerGamma and StieltjesGamma. ", "synonyms" -> {"gamma"},
     "title" -> "\\[Gamma]", "type" -> "Character Name", "uri" -> 
    "ref/character/Gamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2276, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2899, 83, 581, 19, 70, "CharacterImage",
 CellID->307501187],
Cell[3483, 104, 50, 1, 70, "CharacterName",
 CellID->17327],
Cell[3536, 107, 47, 1, 70, "Notes",
 CellID->28441],
Cell[3586, 110, 417, 15, 70, "Notes",
 CellID->9053],
Cell[4006, 127, 46, 1, 70, "Notes",
 CellID->3323],
Cell[4055, 130, 470, 18, 70, "Notes",
 CellID->32528]
}, Open  ]],
Cell[CellGroupData[{
Cell[4562, 153, 52, 1, 70, "TutorialsSection",
 CellID->5491],
Cell[4617, 156, 153, 3, 70, "Tutorials",
 CellID->24597],
Cell[4773, 161, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4983, 169, 50, 1, 70, "SeeAlsoSection",
 CellID->13310],
Cell[5036, 172, 631, 17, 70, "SeeAlso",
 CellID->3671]
}, Open  ]],
Cell[CellGroupData[{
Cell[5704, 194, 58, 1, 70, "MoreAboutSection",
 CellID->105511482],
Cell[5765, 197, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5923, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

