(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8077,        270]
NotebookOptionsPosition[      5976,        205]
NotebookOutlinePosition[      7153,        236]
CellTagsIndexPosition[      7110,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[HumpDownHump]" :> 
          Documentation`HelpLookup["paclet:ref/character/HumpDownHump"], 
          "\\[TildeEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/TildeEqual"], 
          "\\[NotHumpEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotHumpEqual"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[HumpDownHump]\"\>", 
       2->"\<\"\\\\[TildeEqual]\"\>", 
       3->"\<\"\\\\[NotHumpEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[HumpEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[HumpEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->10869310],

Cell["\\[HumpEqual]", "CharacterName",
 CellID->12619],

Cell["Unicode: 224F.", "Notes",
 CellID->24169],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["h=", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->19647],

Cell["Infix similarity operator. ", "Notes",
 CellID->19362],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[HumpEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HumpEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HumpEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12406],

Cell["\<\
Sometimes used to mean \[OpenCurlyDoubleQuote]approximately equal\
\[CloseCurlyDoubleQuote] and sometimes \[OpenCurlyDoubleQuote]difference \
between\[CloseCurlyDoubleQuote]. \
\>", "Notes",
 CellID->24560]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->28752],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->30905]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24380],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[HumpDownHump]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HumpDownHump"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[TildeEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/TildeEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotHumpEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotHumpEqual"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->17441]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->148462242],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[HumpEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 3.2311354}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 224F. Alias: Esc h= Esc. Infix similarity operator. x \
\\[HumpEqual] y is by default interpreted as HumpEqual[x,y]. Sometimes used \
to mean 'approximately equal' and sometimes 'difference between'. ", 
    "synonyms" -> {"hump equal"}, "title" -> "\\[HumpEqual]", "type" -> 
    "Character Name", "uri" -> "ref/character/HumpEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2239, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2862, 82, 588, 19, 70, "CharacterImage",
 CellID->10869310],
Cell[3453, 103, 54, 1, 70, "CharacterName",
 CellID->12619],
Cell[3510, 106, 47, 1, 70, "Notes",
 CellID->24169],
Cell[3560, 109, 234, 9, 70, "Notes",
 CellID->19647],
Cell[3797, 120, 60, 1, 70, "Notes",
 CellID->19362],
Cell[3860, 123, 504, 20, 70, "Notes",
 CellID->12406],
Cell[4367, 145, 216, 5, 70, "Notes",
 CellID->24560]
}, Open  ]],
Cell[CellGroupData[{
Cell[4620, 155, 53, 1, 70, "TutorialsSection",
 CellID->28752],
Cell[4676, 158, 129, 3, 70, "Tutorials",
 CellID->30905]
}, Open  ]],
Cell[CellGroupData[{
Cell[4842, 166, 50, 1, 70, "SeeAlsoSection",
 CellID->24380],
Cell[4895, 169, 638, 17, 70, "SeeAlso",
 CellID->17441]
}, Open  ]],
Cell[CellGroupData[{
Cell[5570, 191, 58, 1, 70, "MoreAboutSection",
 CellID->148462242],
Cell[5631, 194, 143, 2, 70, "MoreAbout"],
Cell[5777, 198, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5949, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

