(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7956,        265]
NotebookOptionsPosition[      5811,        198]
NotebookOutlinePosition[      6975,        229]
CellTagsIndexPosition[      6932,        226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Names of Symbols and Mathematical Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Names of Symbols and Mathematical Objects\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ImaginaryI]" :> 
          Documentation`HelpLookup["paclet:ref/character/ImaginaryI"], 
          "\\[ExponentialE]" :> 
          Documentation`HelpLookup["paclet:ref/character/ExponentialE"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[ImaginaryI]\"\>", 
       2->"\<\"\\\\[ExponentialE]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ImaginaryJ]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ImaginaryJ]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->549857283],

Cell["\\[ImaginaryJ]", "CharacterName",
 CellID->28742],

Cell["Unicode: F74F.", "Notes",
 CellID->21252],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["jj", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->21367],

Cell["\<\
Letter\[Hyphen]like form with built\[Hyphen]in value. \
\>", "Notes",
 CellID->24140],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ImaginaryJ]", TraditionalForm]], "InlineMath"],
 " is interpreted by default as the symbol ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ", representing ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18103],

Cell["Used in electrical engineering. ", "Notes",
 CellID->10855]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->16755],

Cell[TextData[ButtonBox["Names of Symbols and Mathematical Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]], "Tutorials",
 CellID->11052],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2997],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ImaginaryI"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ExponentialE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ExponentialE"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->30650]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->243978046],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ImaginaryJ] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 10.8563306}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F74F. Alias: Esc jj Esc. Letter-like form with built-in value. \
I is interpreted by default as the symbol I, representing SqrtBox[RowBox[{-, \
1}]]. Used in electrical engineering. ", "synonyms" -> {"imaginary j"}, 
    "title" -> "\\[ImaginaryJ]", "type" -> "Character Name", "uri" -> 
    "ref/character/ImaginaryJ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2322, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2945, 82, 591, 19, 70, "CharacterImage",
 CellID->549857283],
Cell[3539, 103, 55, 1, 70, "CharacterName",
 CellID->28742],
Cell[3597, 106, 47, 1, 70, "Notes",
 CellID->21252],
Cell[3647, 109, 234, 9, 70, "Notes",
 CellID->21367],
Cell[3884, 120, 95, 3, 70, "Notes",
 CellID->24140],
Cell[3982, 125, 394, 15, 70, "Notes",
 CellID->18103],
Cell[4379, 142, 65, 1, 70, "Notes",
 CellID->10855]
}, Open  ]],
Cell[CellGroupData[{
Cell[4481, 148, 53, 1, 70, "TutorialsSection",
 CellID->16755],
Cell[4537, 151, 191, 4, 70, "Tutorials",
 CellID->11052],
Cell[4731, 157, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4941, 165, 49, 1, 70, "SeeAlsoSection",
 CellID->2997],
Cell[4993, 168, 411, 11, 70, "SeeAlso",
 CellID->30650]
}, Open  ]],
Cell[CellGroupData[{
Cell[5441, 184, 58, 1, 70, "MoreAboutSection",
 CellID->243978046],
Cell[5502, 187, 143, 2, 70, "MoreAbout"],
Cell[5648, 191, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5784, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

