(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9093,        305]
NotebookOptionsPosition[      6829,        236]
NotebookOutlinePosition[      8100,        268]
CellTagsIndexPosition[      8057,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Union]" :> 
          Documentation`HelpLookup["paclet:ref/character/Union"], 
          "\\[SquareIntersection]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareIntersection"],
           "\\[Cap]" :> Documentation`HelpLookup["paclet:ref/character/Cap"], 
          "\\[Wedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/Wedge"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Union]\"\>", 
       2->"\<\"\\\\[SquareIntersection]\"\>", 3->"\<\"\\\\[Cap]\"\>", 
       4->"\<\"\\\\[Wedge]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Intersection]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Intersection]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->119175432],

Cell["\\[Intersection]", "CharacterName",
 CellID->10264],

Cell["Unicode: 22C2.", "Notes",
 CellID->30666],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["inter", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->30074],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->26692],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Intersection]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30148],

Cell[TextData[{
 "The character ",
 Cell[BoxData[
  FormBox["\[Intersection]", TraditionalForm]], "InlineMath"],
 " is sometimes called \[OpenCurlyDoubleQuote]cap\[CloseCurlyDoubleQuote]; \
but see also ",
 Cell[TextData[ButtonBox["\\[Cap]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cap"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24412],

Cell[TextData[{
 "\[AliasIndicator]",
 Cell[BoxData["int\[AliasIndicator]"], "InlineFormula"],
 " gives ",
 Cell[TextData[ButtonBox["\\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"],
 " not ",
 Cell[TextData[ButtonBox["\\[Intersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Intersection"]], "InlineCharacterName"],
 " . "
}], "Notes",
 CellID->24892]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->216],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->20158],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->18827]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2839],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Union]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SquareIntersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareIntersection"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cap]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cap"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->10163]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->23070873],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Intersection] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 18.1690178}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22C2. Alias: Esc inter Esc. Infix operator with built-in \
evaluation rules. x \\[Intersection] y is by default interpreted as \
Intersection[x,y]. The character \\[Intersection] is sometimes called 'cap'; \
but see also \\[Cap]. ESCintESC gives \\[Integral] not \\[Intersection] . ", 
    "synonyms" -> {"intersection"}, "title" -> "\\[Intersection]", "type" -> 
    "Character Name", "uri" -> "ref/character/Intersection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 82, 595, 19, 70, "CharacterImage",
 CellID->119175432],
Cell[3490, 103, 57, 1, 70, "CharacterName",
 CellID->10264],
Cell[3550, 106, 47, 1, 70, "Notes",
 CellID->30666],
Cell[3600, 109, 237, 9, 70, "Notes",
 CellID->30074],
Cell[3840, 120, 96, 3, 70, "Notes",
 CellID->26692],
Cell[3939, 125, 513, 20, 70, "Notes",
 CellID->30148],
Cell[4455, 147, 365, 11, 70, "Notes",
 CellID->24412],
Cell[4823, 160, 430, 13, 70, "Notes",
 CellID->24892]
}, Open  ]],
Cell[CellGroupData[{
Cell[5290, 178, 51, 1, 70, "TutorialsSection",
 CellID->216],
Cell[5344, 181, 144, 3, 70, "Tutorials",
 CellID->20158],
Cell[5491, 186, 129, 3, 70, "Tutorials",
 CellID->18827]
}, Open  ]],
Cell[CellGroupData[{
Cell[5657, 194, 49, 1, 70, "SeeAlsoSection",
 CellID->2839],
Cell[5709, 197, 838, 24, 70, "SeeAlso",
 CellID->10163]
}, Open  ]],
Cell[CellGroupData[{
Cell[6584, 226, 57, 1, 70, "MoreAboutSection",
 CellID->23070873],
Cell[6644, 229, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6802, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

