(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8366,        273]
NotebookOptionsPosition[      6188,        207]
NotebookOutlinePosition[      7451,        239]
CellTagsIndexPosition[      7408,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[AlignmentMarker]" :> 
          Documentation`HelpLookup["paclet:ref/character/AlignmentMarker"], 
          "\\[Null]" :> Documentation`HelpLookup["paclet:ref/character/Null"],
           "\\[InvisibleSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleSpace"], 
          "\\[RawComma]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawComma"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[AlignmentMarker]\"\>", 
       2->"\<\"\\\\[Null]\"\>", 3->"\<\"\\\\[InvisibleSpace]\"\>", 
       4->"\<\"\\\\[RawComma]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[InvisibleComma]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[InvisibleComma]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->574180883],

Cell["\\[InvisibleComma]", "CharacterName",
 CellID->21069],

Cell["Unicode: F765.", "Notes",
 CellID->7573],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox[",", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->11444],

Cell["\<\
Structural element with built\[Hyphen]in meaning. \
\>", "Notes",
 CellID->1827],

Cell[TextData[{
 Cell["\\[InvisibleComma]", "InlineCharacterName"],
 " is by default not visible on display, but is interpreted on input as an \
ordinary comma. "
}], "Notes",
 CellID->4195],

Cell[TextData[{
 Cell["\\[InvisibleComma]", "InlineCharacterName"],
 " can be used as an invisible separator between indices, as in ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["M", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23336]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30395],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->25102],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->4316]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->16764],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[AlignmentMarker]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AlignmentMarker"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Null]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawComma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawComma"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->9948]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[InvisibleComma] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 18.4971512}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F765. Alias: Esc , Esc. Structural element with built-in \
meaning. \\[InvisibleComma] is by default not visible on display, but is \
interpreted on input as an ordinary comma. \\[InvisibleComma] can be used as \
an invisible separator between indices, as in M_ij. ", 
    "synonyms" -> {"invisible comma"}, "title" -> "\\[InvisibleComma]", 
    "type" -> "Character Name", "uri" -> "ref/character/InvisibleComma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2412, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3035, 84, 599, 19, 70, "CharacterImage",
 CellID->574180883],
Cell[3637, 105, 59, 1, 70, "CharacterName",
 CellID->21069],
Cell[3699, 108, 46, 1, 70, "Notes",
 CellID->7573],
Cell[3748, 111, 233, 9, 70, "Notes",
 CellID->11444],
Cell[3984, 122, 90, 3, 70, "Notes",
 CellID->1827],
Cell[4077, 127, 190, 5, 70, "Notes",
 CellID->4195],
Cell[4270, 134, 270, 9, 70, "Notes",
 CellID->23336]
}, Open  ]],
Cell[CellGroupData[{
Cell[4577, 148, 53, 1, 70, "TutorialsSection",
 CellID->30395],
Cell[4633, 151, 144, 3, 70, "Tutorials",
 CellID->25102],
Cell[4780, 156, 195, 4, 70, "Tutorials",
 CellID->4316]
}, Open  ]],
Cell[CellGroupData[{
Cell[5012, 165, 38, 0, 70, "MoreAboutSection"],
Cell[5053, 167, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5233, 174, 50, 1, 70, "SeeAlsoSection",
 CellID->16764],
Cell[5286, 177, 860, 25, 70, "SeeAlso",
 CellID->9948]
}, Open  ]],
Cell[6161, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

