(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10262,        344]
NotebookOptionsPosition[      7637,        265]
NotebookOutlinePosition[      9059,        299]
CellTagsIndexPosition[      9016,        296]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightAngleBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightAngleBracket"], 
          "\\[LeftFloor]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftFloor"], 
          "\\[LeftCeiling]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftCeiling"], 
          "\\[RawLess]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawLess"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RightAngleBracket]\"\>", 
       2->"\<\"\\\\[LeftFloor]\"\>", 3->"\<\"\\\\[LeftCeiling]\"\>", 
       4->"\<\"\\\\[RawLess]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftAngleBracket]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftAngleBracket]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->80360097],

Cell["\\[LeftAngleBracket]", "CharacterName",
 CellID->7943],

Cell["Unicode: 2329.", "Notes",
 CellID->5035],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["<", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3112],

Cell["Matchfix operator. ", "Notes",
 CellID->8231],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AngleBracket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AngleBracket"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10677],

Cell[TextData[{
 "Used in the form ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " to indicate expected or average value. "
}], "Notes",
 CellID->17049],

Cell["Called bra in quantum mechanics. ", "Notes",
 CellID->1206],

Cell[TextData[{
 "Used in the form ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " to indicate various forms of inner product. "
}], "Notes",
 CellID->20401],

Cell[TextData[{
 "Used in the form ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " to denote an ordered set of objects. "
}], "Notes",
 CellID->21435],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RawLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawLess"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->3546],

Cell["Extensible character; grows by default to limited size. ", "Notes",
 CellID->27959]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->17576],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->16811],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->21708]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->597],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RightAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightAngleBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftFloor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftFloor"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftCeiling]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftCeiling"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawLess"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->19725]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->397924576],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftAngleBracket] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 26.8254894}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2329. Alias: Esc < Esc. Matchfix operator. < x > is by default \
interpreted as AngleBracket[x]. Used in the form <x> to indicate expected or \
average value. Called bra in quantum mechanics. Used in the form <x,y> to \
indicate various forms of inner product. Used in the form <x,y,... > to \
denote an ordered set of objects. Not the same as \\[RawLess]. Extensible \
character; grows by default to limited size. ", 
    "synonyms" -> {"left angle bracket"}, "title" -> "\\[LeftAngleBracket]", 
    "type" -> "Character Name", "uri" -> "ref/character/LeftAngleBracket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2363, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2986, 84, 602, 19, 70, "CharacterImage",
 CellID->80360097],
Cell[3591, 105, 60, 1, 70, "CharacterName",
 CellID->7943],
Cell[3654, 108, 46, 1, 70, "Notes",
 CellID->5035],
Cell[3703, 111, 232, 9, 70, "Notes",
 CellID->3112],
Cell[3938, 122, 51, 1, 70, "Notes",
 CellID->8231],
Cell[3992, 125, 497, 18, 70, "Notes",
 CellID->10677],
Cell[4492, 145, 332, 10, 70, "Notes",
 CellID->17049],
Cell[4827, 157, 65, 1, 70, "Notes",
 CellID->1206],
Cell[4895, 160, 381, 12, 70, "Notes",
 CellID->20401],
Cell[5279, 174, 420, 14, 70, "Notes",
 CellID->21435],
Cell[5702, 190, 203, 7, 70, "Notes",
 CellID->3546],
Cell[5908, 199, 89, 1, 70, "Notes",
 CellID->27959]
}, Open  ]],
Cell[CellGroupData[{
Cell[6034, 205, 53, 1, 70, "TutorialsSection",
 CellID->17576],
Cell[6090, 208, 180, 5, 70, "Tutorials",
 CellID->16811],
Cell[6273, 215, 129, 3, 70, "Tutorials",
 CellID->21708]
}, Open  ]],
Cell[CellGroupData[{
Cell[6439, 223, 48, 1, 70, "SeeAlsoSection",
 CellID->597],
Cell[6490, 226, 864, 24, 70, "SeeAlso",
 CellID->19725]
}, Open  ]],
Cell[CellGroupData[{
Cell[7391, 255, 58, 1, 70, "MoreAboutSection",
 CellID->397924576],
Cell[7452, 258, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7610, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

