(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8753,        292]
NotebookOptionsPosition[      6403,        221]
NotebookOutlinePosition[      7722,        254]
CellTagsIndexPosition[      7679,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawLeftBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawLeftBracket"], 
          "\\[LeftDoubleBracketingBar]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/LeftDoubleBracketingBar"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RawLeftBracket]\"\>", 
       2->"\<\"\\\\[LeftDoubleBracketingBar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftDoubleBracket]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftDoubleBracket]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->432857478],

Cell["\\[LeftDoubleBracket]", "CharacterName",
 CellID->28728],

Cell["Unicode: 301A.", "Notes",
 CellID->15812],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["[[", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->31831],

Cell["\<\
Compound operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->11684],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[LeftDoubleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], ",", 
   StyleBox["j", "TI"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightDoubleBracket]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27293],

Cell["\<\
Sometimes used in mathematics to indicate a class of algebraic objects with \
certain variables or extensions. \
\>", "Notes",
 CellID->14658],

Cell["Extensible character; grows by default to limited size. ", "Notes",
 CellID->5140]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26887],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->19688],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->77]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10530],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawLeftBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawLeftBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftDoubleBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftDoubleBracketingBar"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->28630]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->30421619],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftDoubleBracket] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 34.4975608}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 301A. Alias: Esc [[ Esc. Compound operator with built-in \
evaluation rules. m[[i,j,... ]] is by default interpreted as Part[m,i,j,...]. \
Sometimes used in mathematics to indicate a class of algebraic objects with \
certain variables or extensions. Extensible character; grows by default to \
limited size. ", "synonyms" -> {"left double bracket"}, "title" -> 
    "\\[LeftDoubleBracket]", "type" -> "Character Name", "uri" -> 
    "ref/character/LeftDoubleBracket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2265, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2888, 81, 605, 19, 70, "CharacterImage",
 CellID->432857478],
Cell[3496, 102, 62, 1, 70, "CharacterName",
 CellID->28728],
Cell[3561, 105, 47, 1, 70, "Notes",
 CellID->15812],
Cell[3611, 108, 234, 9, 70, "Notes",
 CellID->31831],
Cell[3848, 119, 99, 3, 70, "Notes",
 CellID->11684],
Cell[3950, 124, 736, 26, 70, "Notes",
 CellID->27293],
Cell[4689, 152, 152, 4, 70, "Notes",
 CellID->14658],
Cell[4844, 158, 88, 1, 70, "Notes",
 CellID->5140]
}, Open  ]],
Cell[CellGroupData[{
Cell[4969, 164, 53, 1, 70, "TutorialsSection",
 CellID->26887],
Cell[5025, 167, 144, 3, 70, "Tutorials",
 CellID->19688],
Cell[5172, 172, 126, 3, 70, "Tutorials",
 CellID->77]
}, Open  ]],
Cell[CellGroupData[{
Cell[5335, 180, 50, 1, 70, "SeeAlsoSection",
 CellID->10530],
Cell[5388, 183, 447, 13, 70, "SeeAlso",
 CellID->28630]
}, Open  ]],
Cell[CellGroupData[{
Cell[5872, 201, 57, 1, 70, "MoreAboutSection",
 CellID->30421619],
Cell[5932, 204, 143, 2, 70, "MoreAbout"],
Cell[6078, 208, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[6376, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

