(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8017,        273]
NotebookOptionsPosition[      5949,        208]
NotebookOutlinePosition[      7098,        239]
CellTagsIndexPosition[      7055,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightFloor]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightFloor"], 
          "\\[LeftCeiling]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftCeiling"], 
          "\\[LeftAngleBracket]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/LeftAngleBracket"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[RightFloor]\"\>", 
       2->"\<\"\\\\[LeftCeiling]\"\>", 
       3->"\<\"\\\\[LeftAngleBracket]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftFloor]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftFloor]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->427664035],

Cell["\\[LeftFloor]", "CharacterName",
 CellID->21890],

Cell["Unicode: 230A.", "Notes",
 CellID->47],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["lf", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->30990],

Cell["\<\
Matchfix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->23340],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftFloor]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightFloor]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26705],

Cell["Extensible character. ", "Notes",
 CellID->6484]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->25643],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->29814]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10298],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RightFloor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightFloor"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftCeiling]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftCeiling"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftAngleBracket"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->7682]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->147986943],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftFloor] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 35.1225768}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 230A. Alias: Esc lf Esc. Matchfix operator with built-in \
evaluation rules. \\[LeftFloor] x \\[RightFloor] is by default interpreted as \
Floor[x]. Extensible character. ", "synonyms" -> {"left floor"}, "title" -> 
    "\\[LeftFloor]", "type" -> "Character Name", "uri" -> 
    "ref/character/LeftFloor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2238, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2861, 82, 589, 19, 70, "CharacterImage",
 CellID->427664035],
Cell[3453, 103, 54, 1, 70, "CharacterName",
 CellID->21890],
Cell[3510, 106, 44, 1, 70, "Notes",
 CellID->47],
Cell[3557, 109, 234, 9, 70, "Notes",
 CellID->30990],
Cell[3794, 120, 99, 3, 70, "Notes",
 CellID->23340],
Cell[3896, 125, 469, 18, 70, "Notes",
 CellID->26705],
Cell[4368, 145, 54, 1, 70, "Notes",
 CellID->6484]
}, Open  ]],
Cell[CellGroupData[{
Cell[4459, 151, 53, 1, 70, "TutorialsSection",
 CellID->25643],
Cell[4515, 154, 129, 3, 70, "Tutorials",
 CellID->29814]
}, Open  ]],
Cell[CellGroupData[{
Cell[4681, 162, 50, 1, 70, "SeeAlsoSection",
 CellID->10298],
Cell[4734, 165, 646, 18, 70, "SeeAlso",
 CellID->7682]
}, Open  ]],
Cell[CellGroupData[{
Cell[5417, 188, 58, 1, 70, "MoreAboutSection",
 CellID->147986943],
Cell[5478, 191, 143, 2, 70, "MoreAbout"],
Cell[5624, 195, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[5922, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

