(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9931,        310]
NotebookOptionsPosition[      7781,        243]
NotebookOutlinePosition[      8957,        274]
CellTagsIndexPosition[      8914,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThinSpace"], 
          "\\[ThickSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThickSpace"], 
          "\\[NegativeMediumSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeMediumSpace"], 
          "\\[NonBreakingSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NonBreakingSpace"], 
          "\\[SpaceIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SpaceIndicator"], 
          "\\[LetterSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/LetterSpace"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"], 
          "\\[VeryThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/VeryThinSpace"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[ThinSpace]\"\>", 
       2->"\<\"\\\\[ThickSpace]\"\>", 3->"\<\"\\\\[NegativeMediumSpace]\"\>", 
       4->"\<\"\\\\[NonBreakingSpace]\"\>", 5->"\<\"\\\\[SpaceIndicator]\"\>",
        6->"\<\"\\\\[LetterSpace]\"\>", 7->"\<\"\\\\[RawSpace]\"\>", 
       8->"\<\"\\\\[VeryThinSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[MediumSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[MediumSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->590514303],

Cell["\\[MediumSpace]", "CharacterName",
 CellID->7485],

Cell["Unicode: 205F.", "Notes",
 CellID->13095],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]", 
  "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->23007],

Cell["Spacing character. ", "Notes",
 CellID->17156],

Cell["Width: 4/18 em. ", "Notes",
 CellID->27544],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->4605],

Cell["\<\
Sometimes used in output as a separator between digits in numbers. \
\>", "Notes",
 CellID->6624]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->16056],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->12250]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->9431],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ThickSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThickSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeMediumSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeMediumSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NonBreakingSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NonBreakingSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LetterSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LetterSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VeryThinSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->31516]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->70078118],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[MediumSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 7.3734024}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 205F. Alias: Esc     Esc. Spacing character. Width: 4/18 em. \
Interpreted by default just like an ordinary \\[RawSpace]. Sometimes used in \
output as a separator between digits in numbers. ", 
    "synonyms" -> {"medium space"}, "title" -> "\\[MediumSpace]", "type" -> 
    "Character Name", "uri" -> "ref/character/MediumSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3097, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3720, 97, 593, 19, 70, "CharacterImage",
 CellID->590514303],
Cell[4316, 118, 55, 1, 70, "CharacterName",
 CellID->7485],
Cell[4374, 121, 47, 1, 70, "Notes",
 CellID->13095],
Cell[4424, 124, 286, 10, 70, "Notes",
 CellID->23007],
Cell[4713, 136, 52, 1, 70, "Notes",
 CellID->17156],
Cell[4768, 139, 49, 1, 70, "Notes",
 CellID->27544],
Cell[4820, 142, 234, 7, 70, "Notes",
 CellID->4605],
Cell[5057, 151, 107, 3, 70, "Notes",
 CellID->6624]
}, Open  ]],
Cell[CellGroupData[{
Cell[5201, 159, 53, 1, 70, "TutorialsSection",
 CellID->16056],
Cell[5257, 162, 196, 4, 70, "Tutorials",
 CellID->12250]
}, Open  ]],
Cell[CellGroupData[{
Cell[5490, 171, 49, 1, 70, "SeeAlsoSection",
 CellID->9431],
Cell[5542, 174, 1794, 50, 70, "SeeAlso",
 CellID->31516]
}, Open  ]],
Cell[CellGroupData[{
Cell[7373, 229, 57, 1, 70, "MoreAboutSection",
 CellID->70078118],
Cell[7433, 232, 143, 2, 70, "MoreAbout"],
Cell[7579, 236, 160, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7754, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

