(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7047,        235]
NotebookOptionsPosition[      5029,        171]
NotebookOutlinePosition[      6167,        202]
CellTagsIndexPosition[      6124,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Flat]" :> 
          Documentation`HelpLookup["paclet:ref/character/Flat"], "\\[Sharp]" :> 
          Documentation`HelpLookup["paclet:ref/character/Sharp"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Flat]\"\>", 
       2->"\<\"\\\\[Sharp]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Natural]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Natural]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->53193119],

Cell["\\[Natural]", "CharacterName",
 CellID->25205],

Cell["Unicode: 266E.", "Notes",
 CellID->7091],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->19691],

Cell["Used to denote musical notes. ", "Notes",
 CellID->9183],

Cell[TextData[{
 "Sometimes used in mathematical notation, often as an inverse of numbering \
operations represented by ",
 Cell[TextData[ButtonBox["\\[Sharp]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sharp"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->6881]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20270],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->32632],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31613],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Flat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Flat"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Sharp]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sharp"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->25374]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->29721026],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Natural] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 14.9829722}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 266E. Letter-like form. Used to denote musical notes. Sometimes \
used in mathematical notation, often as an inverse of numbering operations \
represented by \\[Sharp]. ", "synonyms" -> {"natural"}, "title" -> 
    "\\[Natural]", "type" -> "Character Name", "uri" -> 
    "ref/character/Natural"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2114, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2737, 80, 584, 19, 70, "CharacterImage",
 CellID->53193119],
Cell[3324, 101, 52, 1, 70, "CharacterName",
 CellID->25205],
Cell[3379, 104, 46, 1, 70, "Notes",
 CellID->7091],
Cell[3428, 107, 59, 1, 70, "Notes",
 CellID->19691],
Cell[3490, 110, 62, 1, 70, "Notes",
 CellID->9183],
Cell[3555, 113, 285, 8, 70, "Notes",
 CellID->6881]
}, Open  ]],
Cell[CellGroupData[{
Cell[3877, 126, 53, 1, 70, "TutorialsSection",
 CellID->20270],
Cell[3933, 129, 163, 3, 70, "Tutorials",
 CellID->32632],
Cell[4099, 134, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4309, 142, 50, 1, 70, "SeeAlsoSection",
 CellID->31613],
Cell[4362, 145, 385, 11, 70, "SeeAlso",
 CellID->25374]
}, Open  ]],
Cell[CellGroupData[{
Cell[4784, 161, 57, 1, 70, "MoreAboutSection",
 CellID->29721026],
Cell[4844, 164, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5002, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

