(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7843,        262]
NotebookOptionsPosition[      5714,        196]
NotebookOutlinePosition[      6930,        228]
CellTagsIndexPosition[      6887,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NegativeThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NegativeThinSpace"], 
          "\\[NegativeThickSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NegativeThickSpace"],
           "\\[MediumSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/MediumSpace"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[NegativeThinSpace]\"\>",
        2->"\<\"\\\\[NegativeThickSpace]\"\>", 
       3->"\<\"\\\\[MediumSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NegativeMediumSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NegativeMediumSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->2444709],

Cell["\\[NegativeMediumSpace]", "CharacterName",
 CellID->10494],

Cell["Unicode: F383.", "Notes",
 CellID->12154],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["-\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]", 
  "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->16094],

Cell["Negative spacing character. ", "Notes",
 CellID->23513],

Cell["Used to bring characters on either side closer together. ", "Notes",
 CellID->18538],

Cell[TextData[{
 "Width: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "4"}], "/", "18"}], TraditionalForm]], "InlineMath"],
 " em. "
}], "Notes",
 CellID->2398],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->32505]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20339],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->22073]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21479],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NegativeThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeThickSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThickSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[MediumSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/MediumSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->27217]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NegativeMediumSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 15.1236008}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F383. Alias: Esc -    Esc. Negative spacing character. Used to \
bring characters on either side closer together. Width: -4/18 em. Interpreted \
by default just like an ordinary \\[RawSpace]. ", 
    "synonyms" -> {"negative medium space"}, "title" -> 
    "\\[NegativeMediumSpace]", "type" -> "Character Name", "uri" -> 
    "ref/character/NegativeMediumSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2196, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2819, 81, 607, 19, 70, "CharacterImage",
 CellID->2444709],
Cell[3429, 102, 64, 1, 70, "CharacterName",
 CellID->10494],
Cell[3496, 105, 47, 1, 70, "Notes",
 CellID->12154],
Cell[3546, 108, 287, 10, 70, "Notes",
 CellID->16094],
Cell[3836, 120, 61, 1, 70, "Notes",
 CellID->23513],
Cell[3900, 123, 90, 1, 70, "Notes",
 CellID->18538],
Cell[3993, 126, 173, 8, 70, "Notes",
 CellID->2398],
Cell[4169, 136, 235, 7, 70, "Notes",
 CellID->32505]
}, Open  ]],
Cell[CellGroupData[{
Cell[4441, 148, 53, 1, 70, "TutorialsSection",
 CellID->20339],
Cell[4497, 151, 196, 4, 70, "Tutorials",
 CellID->22073]
}, Open  ]],
Cell[CellGroupData[{
Cell[4730, 160, 38, 0, 70, "MoreAboutSection"],
Cell[4771, 162, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4951, 169, 50, 1, 70, "SeeAlsoSection",
 CellID->21479],
Cell[5004, 172, 668, 19, 70, "SeeAlso",
 CellID->27217]
}, Open  ]],
Cell[5687, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

