(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8674,        282]
NotebookOptionsPosition[      6497,        214]
NotebookOutlinePosition[      7704,        246]
CellTagsIndexPosition[      7661,        243]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NegativeVeryThinSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeVeryThinSpace"], 
          "\\[NegativeMediumSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeMediumSpace"], "\\[ThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThinSpace"], 
          "\\[NegativeThickSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeThickSpace"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[NegativeVeryThinSpace]\"\>", 
       2->"\<\"\\\\[NegativeMediumSpace]\"\>", 3->"\<\"\\\\[ThinSpace]\"\>", 
       4->"\<\"\\\\[NegativeThickSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NegativeThinSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NegativeThinSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->24277426],

Cell["\\[NegativeThinSpace]", "CharacterName",
 CellID->14568],

Cell["Unicode: F382.", "Notes",
 CellID->28192],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["-\[SpaceIndicator]\[SpaceIndicator]", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->23714],

Cell["Negative spacing character. ", "Notes",
 CellID->1741],

Cell["Used to bring characters on either side closer together. ", "Notes",
 CellID->1705],

Cell[TextData[{
 "Width: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "3"}], "/", "18"}], TraditionalForm]], "InlineMath"],
 " em. "
}], "Notes",
 CellID->11694],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->8130]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->17230],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->26598]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4762],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NegativeVeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeVeryThinSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeMediumSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeMediumSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeThickSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThickSpace"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->767]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->112790192],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NegativeThinSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 15.4048580}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F382. Alias: Esc -   Esc. Negative spacing character. Used to \
bring characters on either side closer together. Width: -3/18 em. Interpreted \
by default just like an ordinary \\[RawSpace]. ", 
    "synonyms" -> {"negative thin space"}, "title" -> "\\[NegativeThinSpace]",
     "type" -> "Character Name", "uri" -> 
    "ref/character/NegativeThinSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2578, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3201, 88, 604, 19, 70, "CharacterImage",
 CellID->24277426],
Cell[3808, 109, 62, 1, 70, "CharacterName",
 CellID->14568],
Cell[3873, 112, 47, 1, 70, "Notes",
 CellID->28192],
Cell[3923, 115, 267, 9, 70, "Notes",
 CellID->23714],
Cell[4193, 126, 60, 1, 70, "Notes",
 CellID->1741],
Cell[4256, 129, 89, 1, 70, "Notes",
 CellID->1705],
Cell[4348, 132, 174, 8, 70, "Notes",
 CellID->11694],
Cell[4525, 142, 234, 7, 70, "Notes",
 CellID->8130]
}, Open  ]],
Cell[CellGroupData[{
Cell[4796, 154, 53, 1, 70, "TutorialsSection",
 CellID->17230],
Cell[4852, 157, 196, 4, 70, "Tutorials",
 CellID->26598]
}, Open  ]],
Cell[CellGroupData[{
Cell[5085, 166, 49, 1, 70, "SeeAlsoSection",
 CellID->4762],
Cell[5137, 169, 914, 26, 70, "SeeAlso",
 CellID->767]
}, Open  ]],
Cell[CellGroupData[{
Cell[6088, 200, 58, 1, 70, "MoreAboutSection",
 CellID->112790192],
Cell[6149, 203, 143, 2, 70, "MoreAbout"],
Cell[6295, 207, 160, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6470, 212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

