(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8182,        264]
NotebookOptionsPosition[      6276,        204]
NotebookOutlinePosition[      7372,        234]
CellTagsIndexPosition[      7329,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NonBreakingSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NonBreakingSpace"], 
          "\\[NewLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/NewLine"], 
          "\\[Continuation]" :> 
          Documentation`HelpLookup["paclet:ref/character/Continuation"], 
          "\\[AlignmentMarker]" :> 
          Documentation`HelpLookup["paclet:ref/character/AlignmentMarker"], 
          "\\[Null]" :> Documentation`HelpLookup["paclet:ref/character/Null"],
           "\\[InvisibleSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleSpace"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[NonBreakingSpace]\"\>",
        2->"\<\"\\\\[NewLine]\"\>", 3->"\<\"\\\\[Continuation]\"\>", 
       4->"\<\"\\\\[AlignmentMarker]\"\>", 5->"\<\"\\\\[Null]\"\>", 
       6->"\<\"\\\\[InvisibleSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\:f3a2\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\:f3a2\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->352424533],

Cell["\\[NoBreak]", "CharacterName",
 CellID->4438],

Cell["Unicode: 2060.", "Notes",
 CellID->215497632],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["nb", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->10120],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->24912],

Cell["\<\
Used to indicate that no line break can occur at this position in an \
expression. \
\>", "Notes",
 CellID->16897]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->9605],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->1789]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19435],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NonBreakingSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NonBreakingSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Continuation]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Continuation"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[AlignmentMarker]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AlignmentMarker"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Null]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->30990]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NoBreak] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 22.9206754}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2060. Alias: Esc nb Esc. Letter-like form. Used to indicate \
that no line break can occur at this position in an expression. ", 
    "synonyms" -> {"no break"}, "title" -> "\\[NoBreak]", "type" -> 
    "Character Name", "uri" -> "ref/character/NoBreak"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2581, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3204, 88, 577, 19, 70, "CharacterImage",
 CellID->352424533],
Cell[3784, 109, 51, 1, 70, "CharacterName",
 CellID->4438],
Cell[3838, 112, 51, 1, 70, "Notes",
 CellID->215497632],
Cell[3892, 115, 234, 9, 70, "Notes",
 CellID->10120],
Cell[4129, 126, 59, 1, 70, "Notes",
 CellID->24912],
Cell[4191, 129, 124, 4, 70, "Notes",
 CellID->16897]
}, Open  ]],
Cell[CellGroupData[{
Cell[4352, 138, 52, 1, 70, "TutorialsSection",
 CellID->9605],
Cell[4407, 141, 195, 4, 70, "Tutorials",
 CellID->1789]
}, Open  ]],
Cell[CellGroupData[{
Cell[4639, 150, 38, 0, 70, "MoreAboutSection"],
Cell[4680, 152, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4860, 159, 50, 1, 70, "SeeAlsoSection",
 CellID->19435],
Cell[4913, 162, 1321, 37, 70, "SeeAlso",
 CellID->30990]
}, Open  ]],
Cell[6249, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

