(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7665,        250]
NotebookOptionsPosition[      5686,        189]
NotebookOutlinePosition[      6859,        220]
CellTagsIndexPosition[      6816,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NoBreak]" :> 
          Documentation`HelpLookup["paclet:ref/character/NoBreak"], 
          "\\[InvisibleSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleSpace"], 
          "\\[NewLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/NewLine"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[NoBreak]\"\>", 
       2->"\<\"\\\\[InvisibleSpace]\"\>", 3->"\<\"\\\\[NewLine]\"\>", 
       4->"\<\"\\\\[RawSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NonBreakingSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NonBreakingSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->84382787],

Cell["\\[NonBreakingSpace]", "CharacterName",
 CellID->3356],

Cell["Unicode: 00A0.", "Notes",
 CellID->89938305],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["nbs", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->14901],

Cell["Spacing character. ", "Notes",
 CellID->20318],

Cell[TextData[{
 "Generates a space with the same width as ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ", but with no line break allowed to occur on either side of it. "
}], "Notes",
 CellID->3905]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->6768],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->22187]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18655],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NoBreak]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NoBreak"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->6335]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NonBreakingSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 23.0613040}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00A0. Alias: Esc nbs Esc. Spacing character. Generates a space \
with the same width as \\[RawSpace], but with no line break allowed to occur \
on either side of it. ", "synonyms" -> {"non breaking space"}, "title" -> 
    "\\[NonBreakingSpace]", "type" -> "Character Name", "uri" -> 
    "ref/character/NonBreakingSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 83, 602, 19, 70, "CharacterImage",
 CellID->84382787],
Cell[3497, 104, 60, 1, 70, "CharacterName",
 CellID->3356],
Cell[3560, 107, 50, 1, 70, "Notes",
 CellID->89938305],
Cell[3613, 110, 235, 9, 70, "Notes",
 CellID->14901],
Cell[3851, 121, 52, 1, 70, "Notes",
 CellID->20318],
Cell[3906, 124, 292, 7, 70, "Notes",
 CellID->3905]
}, Open  ]],
Cell[CellGroupData[{
Cell[4235, 136, 52, 1, 70, "TutorialsSection",
 CellID->6768],
Cell[4290, 139, 196, 4, 70, "Tutorials",
 CellID->22187]
}, Open  ]],
Cell[CellGroupData[{
Cell[4523, 148, 38, 0, 70, "MoreAboutSection"],
Cell[4564, 150, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4744, 157, 50, 1, 70, "SeeAlsoSection",
 CellID->18655],
Cell[4797, 160, 847, 24, 70, "SeeAlso",
 CellID->6335]
}, Open  ]],
Cell[5659, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

