(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7279,        254]
NotebookOptionsPosition[      5236,        190]
NotebookOutlinePosition[      6360,        220]
CellTagsIndexPosition[      6317,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawLess]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawLess"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\\[RawLess]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NotLess]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NotLess]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->475760203],

Cell["\\[NotLess]", "CharacterName",
 CellID->4761],

Cell["Unicode: 226E.", "Notes",
 CellID->24339],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["!<", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->28928],

Cell["Infix ordering operator. ", "Notes",
 CellID->12315],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[NotLess]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotLess",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotLess"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17235],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[NotLess]", TraditionalForm]], "InlineMath"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox["\[GreaterEqual]", TraditionalForm]], "InlineMath"],
 " only for a totally ordered set. "
}], "Notes",
 CellID->19071]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->6963],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->15454]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->6266],

Cell[TextData[Cell[TextData[ButtonBox["\\[RawLess]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/character/RawLess"]], "InlineCharacterName"]], "SeeAlso",
 CellID->17605]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->54626319],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NotLess] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 46.3275246}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 226E. Alias: Esc !< Esc. Infix ordering operator. x !< y is by \
default interpreted as NotLess[x,y]. !< is equivalent to >= only for a \
totally ordered set. ", "synonyms" -> {"not less"}, "title" -> "\\[NotLess]", 
    "type" -> "Character Name", "uri" -> "ref/character/NotLess"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1941, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2564, 77, 585, 19, 70, "CharacterImage",
 CellID->475760203],
Cell[3152, 98, 51, 1, 70, "CharacterName",
 CellID->4761],
Cell[3206, 101, 47, 1, 70, "Notes",
 CellID->24339],
Cell[3256, 104, 234, 9, 70, "Notes",
 CellID->28928],
Cell[3493, 115, 58, 1, 70, "Notes",
 CellID->12315],
Cell[3554, 118, 498, 20, 70, "Notes",
 CellID->17235],
Cell[4055, 140, 255, 8, 70, "Notes",
 CellID->19071]
}, Open  ]],
Cell[CellGroupData[{
Cell[4347, 153, 52, 1, 70, "TutorialsSection",
 CellID->6963],
Cell[4402, 156, 129, 3, 70, "Tutorials",
 CellID->15454]
}, Open  ]],
Cell[CellGroupData[{
Cell[4568, 164, 49, 1, 70, "SeeAlsoSection",
 CellID->6266],
Cell[4620, 167, 174, 4, 70, "SeeAlso",
 CellID->17605]
}, Open  ]],
Cell[CellGroupData[{
Cell[4831, 176, 57, 1, 70, "MoreAboutSection",
 CellID->54626319],
Cell[4891, 179, 143, 2, 70, "MoreAbout"],
Cell[5037, 183, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5209, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

