(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7105,        239]
NotebookOptionsPosition[      5178,        177]
NotebookOutlinePosition[      6220,        206]
CellTagsIndexPosition[      6177,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Non\[Hyphen]English Characters and Keyboards" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Non\[Hyphen]English Characters and Keyboards\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ODoubleAcute]" :> 
          Documentation`HelpLookup["paclet:ref/character/ODoubleAcute"], 
          "\\[CapitalODoubleDot]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/CapitalODoubleDot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[ODoubleAcute]\"\>", 
       2->"\<\"\\\\[CapitalODoubleDot]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ODoubleDot]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ODoubleDot]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->582745880],

Cell["\\[ODoubleDot]", "CharacterName",
 CellID->12056],

Cell["Unicode: 00F6.", "Notes",
 CellID->26057803],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["o\"", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->13811],

Cell["Letter. ", "Notes",
 CellID->3501],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->32525]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19697],

Cell[TextData[ButtonBox["Non\[Hyphen]English Characters and Keyboards",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonEnglishCharactersAndKeyboards"]], "Tutorials",\

 CellID->6700],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->16451],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ODoubleAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ODoubleAcute"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalODoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalODoubleDot"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->4810]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->283549936],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ODoubleDot] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 18.1564644}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00F6. Alias: Esc o\" Esc. Letter. Included in ISO Latin-1. ", 
    "synonyms" -> {"o double dot"}, "title" -> "\\[ODoubleDot]", "type" -> 
    "Character Name", "uri" -> "ref/character/ODoubleDot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2246, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2869, 83, 591, 19, 70, "CharacterImage",
 CellID->582745880],
Cell[3463, 104, 55, 1, 70, "CharacterName",
 CellID->12056],
Cell[3521, 107, 50, 1, 70, "Notes",
 CellID->26057803],
Cell[3574, 110, 235, 9, 70, "Notes",
 CellID->13811],
Cell[3812, 121, 40, 1, 70, "Notes",
 CellID->3501],
Cell[3855, 124, 66, 1, 70, "Notes",
 CellID->32525]
}, Open  ]],
Cell[CellGroupData[{
Cell[3958, 130, 53, 1, 70, "TutorialsSection",
 CellID->19697],
Cell[4014, 133, 188, 4, 70, "Tutorials",
 CellID->6700],
Cell[4205, 139, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4415, 147, 50, 1, 70, "SeeAlsoSection",
 CellID->16451],
Cell[4468, 150, 427, 12, 70, "SeeAlso",
 CellID->4810]
}, Open  ]],
Cell[CellGroupData[{
Cell[4932, 167, 58, 1, 70, "MoreAboutSection",
 CellID->283549936],
Cell[4993, 170, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5151, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

