(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7667,        258]
NotebookOptionsPosition[      5673,        193]
NotebookOutlinePosition[      6729,        223]
CellTagsIndexPosition[      6686,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Non\[Hyphen]English Characters and Keyboards" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Non\[Hyphen]English Characters and Keyboards\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CapitalOSlash]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalOSlash"], 
          "\\[EmptySet]" :> 
          Documentation`HelpLookup["paclet:ref/character/EmptySet"], 
          "\\[Diameter]" :> 
          Documentation`HelpLookup["paclet:ref/character/Diameter"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[CapitalOSlash]\"\>", 
       2->"\<\"\\\\[EmptySet]\"\>", 
       3->"\<\"\\\\[Diameter]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[OSlash]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[OSlash]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->352087673],

Cell["\\[OSlash]", "CharacterName",
 CellID->1266],

Cell["Unicode: 00F8.", "Notes",
 CellID->137689919],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["o/", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->18605],

Cell["Letter. ", "Notes",
 CellID->4592],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->6607],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[EmptySet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySet"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28523]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->7777],

Cell[TextData[ButtonBox["Non\[Hyphen]English Characters and Keyboards",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonEnglishCharactersAndKeyboards"]], "Tutorials",\

 CellID->23503],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21557],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CapitalOSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalOSlash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptySet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySet"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Diameter]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Diameter"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->5174]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210308741],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[OSlash] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 19.5002488}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00F8. Alias: Esc o/ Esc. Letter. Included in ISO Latin-1. Not \
the same as \\[EmptySet]. ", "synonyms" -> {"o slash"}, "title" -> 
    "\\[OSlash]", "type" -> "Character Name", "uri" -> 
    "ref/character/OSlash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2346, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2969, 85, 583, 19, 70, "CharacterImage",
 CellID->352087673],
Cell[3555, 106, 50, 1, 70, "CharacterName",
 CellID->1266],
Cell[3608, 109, 51, 1, 70, "Notes",
 CellID->137689919],
Cell[3662, 112, 234, 9, 70, "Notes",
 CellID->18605],
Cell[3899, 123, 40, 1, 70, "Notes",
 CellID->4592],
Cell[3942, 126, 65, 1, 70, "Notes",
 CellID->6607],
Cell[4010, 129, 206, 7, 70, "Notes",
 CellID->28523]
}, Open  ]],
Cell[CellGroupData[{
Cell[4253, 141, 52, 1, 70, "TutorialsSection",
 CellID->7777],
Cell[4308, 144, 189, 4, 70, "Tutorials",
 CellID->23503],
Cell[4500, 150, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4710, 158, 50, 1, 70, "SeeAlsoSection",
 CellID->21557],
Cell[4763, 161, 627, 17, 70, "SeeAlso",
 CellID->5174]
}, Open  ]],
Cell[CellGroupData[{
Cell[5427, 183, 58, 1, 70, "MoreAboutSection",
 CellID->210308741],
Cell[5488, 186, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5646, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

