(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9457,        322]
NotebookOptionsPosition[      7244,        252]
NotebookOutlinePosition[      8406,        283]
CellTagsIndexPosition[      8363,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[And]" :> 
          Documentation`HelpLookup["paclet:ref/character/And"], "\\[Xor]" :> 
          Documentation`HelpLookup["paclet:ref/character/Xor"], "\\[Nor]" :> 
          Documentation`HelpLookup["paclet:ref/character/Nor"], "\\[Not]" :> 
          Documentation`HelpLookup["paclet:ref/character/Not"], "\\[Vee]" :> 
          Documentation`HelpLookup["paclet:ref/character/Vee"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[And]\"\>", 
       2->"\<\"\\\\[Xor]\"\>", 3->"\<\"\\\\[Nor]\"\>", 4->"\<\"\\\\[Not]\"\>",
        5->"\<\"\\\\[Vee]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Or]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Or]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->62568848],

Cell["\\[Or]", "CharacterName",
 CellID->9590],

Cell["Unicode: 2228.", "Notes",
 CellID->17751],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["||", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["or", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->12152],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->30582],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Or]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "||", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8522],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Vee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->8082],

Cell[TextData[{
 "Drawn slightly larger than ",
 Cell[TextData[ButtonBox["\\[Vee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28125]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->12869],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->30502],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->21091],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->25209]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10115],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[And]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Xor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Xor"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Nor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Nor"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Not]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Not"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Vee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->32243]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->480252928],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Or] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 19.3596202}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2228. Aliases: Esc || Esc, Esc or Esc. Infix operator with \
built-in evaluation rules. x || y is by default interpreted as Or[x,y], \
equivalent to x||y. Not the same as \\[Vee]. Drawn slightly larger than \
\\[Vee]. ", "synonyms" -> {"or"}, "title" -> "\\[Or]", "type" -> 
    "Character Name", "uri" -> "ref/character/Or"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2483, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3106, 85, 574, 19, 70, "CharacterImage",
 CellID->62568848],
Cell[3683, 106, 46, 1, 70, "CharacterName",
 CellID->9590],
Cell[3732, 109, 47, 1, 70, "Notes",
 CellID->17751],
Cell[3782, 112, 416, 15, 70, "Notes",
 CellID->12152],
Cell[4201, 129, 96, 3, 70, "Notes",
 CellID->30582],
Cell[4300, 134, 605, 25, 70, "Notes",
 CellID->8522],
Cell[4908, 161, 195, 7, 70, "Notes",
 CellID->8082],
Cell[5106, 170, 207, 7, 70, "Notes",
 CellID->28125]
}, Open  ]],
Cell[CellGroupData[{
Cell[5350, 182, 53, 1, 70, "TutorialsSection",
 CellID->12869],
Cell[5406, 185, 144, 3, 70, "Tutorials",
 CellID->30502],
Cell[5553, 190, 180, 5, 70, "Tutorials",
 CellID->21091],
Cell[5736, 197, 129, 3, 70, "Tutorials",
 CellID->25209]
}, Open  ]],
Cell[CellGroupData[{
Cell[5902, 205, 50, 1, 70, "SeeAlsoSection",
 CellID->10115],
Cell[5955, 208, 1006, 29, 70, "SeeAlso",
 CellID->32243]
}, Open  ]],
Cell[CellGroupData[{
Cell[6998, 242, 58, 1, 70, "MoreAboutSection",
 CellID->480252928],
Cell[7059, 245, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7217, 250, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

