(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9666,        322]
NotebookOptionsPosition[      7215,        248]
NotebookOutlinePosition[      8562,        281]
CellTagsIndexPosition[      8519,        278]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Delta]" :> 
          Documentation`HelpLookup["paclet:ref/character/Delta"], "\\[Del]" :> 
          Documentation`HelpLookup["paclet:ref/character/Del"], 
          "\\[DifferentialD]" :> 
          Documentation`HelpLookup["paclet:ref/character/DifferentialD"], 
          "\\[Eth]" :> 
          Documentation`HelpLookup["paclet:ref/character/Eth"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Delta]\"\>", 
       2->"\<\"\\\\[Del]\"\>", 3->"\<\"\\\\[DifferentialD]\"\>", 
       4->"\<\"\\\\[Eth]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[PartialD]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[PartialD]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->129136944],

Cell["\\[PartialD]", "CharacterName",
 CellID->28393],

Cell["Unicode: 2202.", "Notes",
 CellID->11363],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["pd", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->29802],

Cell["\<\
Prefix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->28069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[PartialD]", 
    StyleBox["x", "TI"]], 
   StyleBox["y", "TI"]}]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21999],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[PartialD]", TraditionalForm]], "InlineMath"],
 " is used in mathematics to indicate boundary. "
}], "Notes",
 CellID->2380],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]d\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " gives ",
 Cell[TextData[ButtonBox["\\[Delta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Delta"]], "InlineCharacterName"],
 ", not \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", "PartialD", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12789],

Cell[TextData[{
 "You can use ",
 Cell[TextData[ButtonBox["\\[InvisibleComma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleComma"]], 
  "InlineCharacterName"],
 " in the subscript to ",
 Cell[BoxData[
  FormBox["\[PartialD]", TraditionalForm]], "InlineMath"],
 " to give several variables without having them separated by visible commas. \
"
}], "Notes",
 CellID->6509]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->410],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->17366],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->13158]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->9951],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Delta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Delta"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Del]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Del"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DifferentialD"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Eth]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Eth"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->22859]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->265916253],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[PartialD] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 27.0629424}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2202. Alias: Esc pd Esc. Prefix operator with built-in \
evaluation rules. \\[PartialD]_xy is by default interpreted as D[y,x]. \
\\[PartialD] is used in mathematics to indicate boundary. Esc d Esc gives \
\\[Delta], not \\[PartialD]. You can use \\[InvisibleComma] in the subscript \
to \\[PartialD] to give several variables without having them separated by \
visible commas. ", "synonyms" -> {"partial d"}, "title" -> "\\[PartialD]", 
    "type" -> "Character Name", "uri" -> "ref/character/PartialD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2445, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3068, 85, 587, 19, 70, "CharacterImage",
 CellID->129136944],
Cell[3658, 106, 53, 1, 70, "CharacterName",
 CellID->28393],
Cell[3714, 109, 47, 1, 70, "Notes",
 CellID->11363],
Cell[3764, 112, 234, 9, 70, "Notes",
 CellID->29802],
Cell[4001, 123, 97, 3, 70, "Notes",
 CellID->28069],
Cell[4101, 128, 414, 17, 70, "Notes",
 CellID->21999],
Cell[4518, 147, 167, 5, 70, "Notes",
 CellID->2380],
Cell[4688, 154, 396, 13, 70, "Notes",
 CellID->12789],
Cell[5087, 169, 392, 12, 70, "Notes",
 CellID->6509]
}, Open  ]],
Cell[CellGroupData[{
Cell[5516, 186, 51, 1, 70, "TutorialsSection",
 CellID->410],
Cell[5570, 189, 144, 3, 70, "Tutorials",
 CellID->17366],
Cell[5717, 194, 173, 3, 70, "Tutorials",
 CellID->20037],
Cell[5893, 199, 129, 3, 70, "Tutorials",
 CellID->13158]
}, Open  ]],
Cell[CellGroupData[{
Cell[6059, 207, 49, 1, 70, "SeeAlsoSection",
 CellID->9951],
Cell[6111, 210, 821, 23, 70, "SeeAlso",
 CellID->22859]
}, Open  ]],
Cell[CellGroupData[{
Cell[6969, 238, 58, 1, 70, "MoreAboutSection",
 CellID->265916253],
Cell[7030, 241, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7188, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

