(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7620,        259]
NotebookOptionsPosition[      5673,        196]
NotebookOutlinePosition[      6737,        226]
CellTagsIndexPosition[      6694,        223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[DoubledPi]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubledPi"], 
          "\\[CapitalPi]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalPi"], 
          "\\[CurlyPi]" :> 
          Documentation`HelpLookup["paclet:ref/character/CurlyPi"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[DoubledPi]\"\>", 
       2->"\<\"\\\\[CapitalPi]\"\>", 
       3->"\<\"\\\\[CurlyPi]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Pi]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Pi]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->585336133],

Cell["\\[Pi]", "CharacterName",
 CellID->14870],

Cell["Unicode: 03C0.", "Notes",
 CellID->24716],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["p", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["pi", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9562],

Cell["\<\
Greek letter with built\[Hyphen]in value. \
\>", "Notes",
 CellID->18197],

Cell[TextData[{
 "Interpreted by default as the symbol ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1893]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->2661],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->16878],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2075],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[DoubledPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubledPi"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalPi"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CurlyPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyPi"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->27035]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->183644460],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Pi] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 27.5160790}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03C0. Aliases: Esc p Esc, Esc pi Esc. Greek letter with \
built-in value. Interpreted by default as the symbol Pi. ", 
    "synonyms" -> {"pi"}, "title" -> "\\[Pi]", "type" -> "Character Name", 
    "uri" -> "ref/character/Pi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2258, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2881, 83, 575, 19, 70, "CharacterImage",
 CellID->585336133],
Cell[3459, 104, 47, 1, 70, "CharacterName",
 CellID->14870],
Cell[3509, 107, 47, 1, 70, "Notes",
 CellID->24716],
Cell[3559, 110, 414, 15, 70, "Notes",
 CellID->9562],
Cell[3976, 127, 83, 3, 70, "Notes",
 CellID->18197],
Cell[4062, 132, 198, 8, 70, "Notes",
 CellID->1893]
}, Open  ]],
Cell[CellGroupData[{
Cell[4297, 145, 52, 1, 70, "TutorialsSection",
 CellID->2661],
Cell[4352, 148, 153, 3, 70, "Tutorials",
 CellID->16878],
Cell[4508, 153, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4718, 161, 49, 1, 70, "SeeAlsoSection",
 CellID->2075],
Cell[4770, 164, 620, 17, 70, "SeeAlso",
 CellID->27035]
}, Open  ]],
Cell[CellGroupData[{
Cell[5427, 186, 58, 1, 70, "MoreAboutSection",
 CellID->183644460],
Cell[5488, 189, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5646, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

