(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7263,        256]
NotebookOptionsPosition[      5114,        193]
NotebookOutlinePosition[      6445,        226]
CellTagsIndexPosition[      6402,        223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Special Characters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Piecewise]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Piecewise]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->22083535],

Cell["\\[Piecewise]", "CharacterName",
 CellID->930],

Cell["Unicode: F361.", "Notes",
 CellID->20640],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["pw", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->8839],

Cell["\<\
Prefix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->3234],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Piecewise]", GridBox[{
     {
      StyleBox[
       SubscriptBox["e", "1"], "TI"], 
      StyleBox[
       SubscriptBox["c", "1"], "TI"]},
     {
      StyleBox[
       SubscriptBox["e", "2"], "TI"], 
      StyleBox[
       SubscriptBox["c", "2"], "TI"]}
    }]}]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20367],

Cell["Extensible character. ", "Notes",
 CellID->24829],

Cell[TextData[{
 "Not the same as keyboard ",
 Cell[BoxData["{"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17479]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8475],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->20023]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->466534475],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Piecewise] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 27.3598250}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F361. Alias: Esc pw Esc. Prefix operator with built-in \
evaluation rules. \\[Piecewise]GridBox[{{StyleBox[SubscriptBox[e, 1], TI], \
StyleBox[SubscriptBox[c, 1], TI]}, {StyleBox[SubscriptBox[e, 2], TI], \
StyleBox[SubscriptBox[c, 2], TI]}}] is by default interpreted as \
Piecewise[{{e_1,c_1},{e_2,c_2}}]. Extensible character. Not the same as \
keyboard {. ", "synonyms" -> {"piecewise"}, "title" -> "\\[Piecewise]", 
    "type" -> "Character Name", "uri" -> "ref/character/Piecewise"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1430, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2053, 62, 588, 19, 70, "CharacterImage",
 CellID->22083535],
Cell[2644, 83, 52, 1, 70, "CharacterName",
 CellID->930],
Cell[2699, 86, 47, 1, 70, "Notes",
 CellID->20640],
Cell[2749, 89, 233, 9, 70, "Notes",
 CellID->8839],
Cell[2985, 100, 96, 3, 70, "Notes",
 CellID->3234],
Cell[3084, 105, 1010, 40, 70, "Notes",
 CellID->20367],
Cell[4097, 147, 55, 1, 70, "Notes",
 CellID->24829],
Cell[4155, 150, 118, 5, 70, "Notes",
 CellID->17479]
}, Open  ]],
Cell[CellGroupData[{
Cell[4310, 160, 52, 1, 70, "TutorialsSection",
 CellID->8475],
Cell[4365, 163, 180, 5, 70, "Tutorials",
 CellID->20023]
}, Open  ]],
Cell[CellGroupData[{
Cell[4582, 173, 58, 1, 70, "MoreAboutSection",
 CellID->466534475],
Cell[4643, 176, 143, 2, 70, "MoreAbout"],
Cell[4789, 180, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[5087, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

