(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7966,        263]
NotebookOptionsPosition[      5940,        200]
NotebookOutlinePosition[      7096,        231]
CellTagsIndexPosition[      7053,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Divide]" :> 
          Documentation`HelpLookup["paclet:ref/character/Divide"], 
          "\\[Proportional]" :> 
          Documentation`HelpLookup["paclet:ref/character/Proportional"], 
          "\\[Colon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Colon"], 
          "\\[Therefore]" :> 
          Documentation`HelpLookup["paclet:ref/character/Therefore"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Divide]\"\>", 
       2->"\<\"\\\\[Proportional]\"\>", 3->"\<\"\\\\[Colon]\"\>", 
       4->"\<\"\\\\[Therefore]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Proportion]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Proportion]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->720034604],

Cell["\\[Proportion]", "CharacterName",
 CellID->26849],

Cell["Unicode: 2237.", "Notes",
 CellID->12543],

Cell["Infix relational operator. ", "Notes",
 CellID->18662],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Proportion]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Proportion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Proportion"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7071],

Cell["\<\
Used historically to indicate equality; now used to indicate proportion. \
\>", "Notes",
 CellID->21149]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->25814],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->31361]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23100],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Divide]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Divide"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Proportional]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Proportional"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Colon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Colon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Therefore]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Therefore"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->21004]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->374043285],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Proportion] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 42.1570788}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2237. Infix relational operator. x \\[Proportion] y is by \
default interpreted as Proportion[x,y]. Used historically to indicate \
equality; now used to indicate proportion. ", "synonyms" -> {"proportion"}, 
    "title" -> "\\[Proportion]", "type" -> "Character Name", "uri" -> 
    "ref/character/Proportion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2337, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2960, 84, 591, 19, 70, "CharacterImage",
 CellID->720034604],
Cell[3554, 105, 55, 1, 70, "CharacterName",
 CellID->26849],
Cell[3612, 108, 47, 1, 70, "Notes",
 CellID->12543],
Cell[3662, 111, 60, 1, 70, "Notes",
 CellID->18662],
Cell[3725, 114, 506, 20, 70, "Notes",
 CellID->7071],
Cell[4234, 136, 114, 3, 70, "Notes",
 CellID->21149]
}, Open  ]],
Cell[CellGroupData[{
Cell[4385, 144, 53, 1, 70, "TutorialsSection",
 CellID->25814],
Cell[4441, 147, 129, 3, 70, "Tutorials",
 CellID->31361]
}, Open  ]],
Cell[CellGroupData[{
Cell[4607, 155, 50, 1, 70, "SeeAlsoSection",
 CellID->23100],
Cell[4660, 158, 837, 23, 70, "SeeAlso",
 CellID->21004]
}, Open  ]],
Cell[CellGroupData[{
Cell[5534, 186, 58, 1, 70, "MoreAboutSection",
 CellID->374043285],
Cell[5595, 189, 143, 2, 70, "MoreAbout"],
Cell[5741, 193, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5913, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

