(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8025,        272]
NotebookOptionsPosition[      5902,        205]
NotebookOutlinePosition[      7045,        236]
CellTagsIndexPosition[      7002,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Proportion]" :> 
          Documentation`HelpLookup["paclet:ref/character/Proportion"], 
          "\\[Alpha]" :> 
          Documentation`HelpLookup["paclet:ref/character/Alpha"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Proportion]\"\>", 
       2->"\<\"\\\\[Alpha]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Proportional]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Proportional]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->14918393],

Cell["\\[Proportional]", "CharacterName",
 CellID->15521],

Cell["Unicode: 221D.", "Notes",
 CellID->1589],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["prop", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->28991],

Cell["Infix relational operator. ", "Notes",
 CellID->24193],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Proportional]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Proportional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Proportional"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14990],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Alpha]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Alpha"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28189]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8892],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->25515],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->24165]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->13589],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Proportion]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Proportion"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Alpha]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Alpha"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->31136]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->559846984],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Proportional] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 35.5631600}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 221D. Alias: Esc prop Esc. Infix relational operator. x \
\\[Proportional] y is by default interpreted as Proportional[x,y]. Not the \
same as \\[Alpha]. ", "synonyms" -> {"proportional"}, "title" -> 
    "\\[Proportional]", "type" -> "Character Name", "uri" -> 
    "ref/character/Proportional"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2238, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2861, 81, 594, 19, 70, "CharacterImage",
 CellID->14918393],
Cell[3458, 102, 57, 1, 70, "CharacterName",
 CellID->15521],
Cell[3518, 105, 46, 1, 70, "Notes",
 CellID->1589],
Cell[3567, 108, 236, 9, 70, "Notes",
 CellID->28991],
Cell[3806, 119, 60, 1, 70, "Notes",
 CellID->24193],
Cell[3869, 122, 513, 20, 70, "Notes",
 CellID->14990],
Cell[4385, 144, 200, 7, 70, "Notes",
 CellID->28189]
}, Open  ]],
Cell[CellGroupData[{
Cell[4622, 156, 52, 1, 70, "TutorialsSection",
 CellID->8892],
Cell[4677, 159, 163, 3, 70, "Tutorials",
 CellID->25515],
Cell[4843, 164, 129, 3, 70, "Tutorials",
 CellID->24165]
}, Open  ]],
Cell[CellGroupData[{
Cell[5009, 172, 50, 1, 70, "SeeAlsoSection",
 CellID->13589],
Cell[5062, 175, 397, 11, 70, "SeeAlso",
 CellID->31136]
}, Open  ]],
Cell[CellGroupData[{
Cell[5496, 191, 58, 1, 70, "MoreAboutSection",
 CellID->559846984],
Cell[5557, 194, 143, 2, 70, "MoreAbout"],
Cell[5703, 198, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5875, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

