(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6137,        208]
NotebookOptionsPosition[      4229,        148]
NotebookOutlinePosition[      5329,        178]
CellTagsIndexPosition[      5286,        175]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Backslash]" :> 
          Documentation`HelpLookup["paclet:ref/character/Backslash"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[Backslash]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\\\\\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\\\\\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->212952660],

Cell["\\[RawBackslash]", "CharacterName",
 CellID->23324],

Cell["Unicode: 005C.", "Notes",
 CellID->604282963],

Cell["Raw operator. ", "Notes",
 CellID->23935],

Cell["Equivalent to the ordinary ASCII character with code 92. ", "Notes",
 CellID->15580],

Cell["Equivalent in strings to \[Backslash]\[Backslash]. ", "Notes",
 CellID->25132]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11061],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->23452]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21486],

Cell[TextData[Cell[TextData[ButtonBox["\\[Backslash]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/character/Backslash"]], "InlineCharacterName"]], "SeeAlso",
 CellID->28717]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawBackslash] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 43.2664822}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 005C. Raw operator. Equivalent to the ordinary ASCII character \
with code 92. Equivalent in strings to \\\\. ", 
    "synonyms" -> {"raw backslash"}, "title" -> "\\[RawBackslash]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawBackslash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1869, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2492, 76, 573, 19, 70, "CharacterImage",
 CellID->212952660],
Cell[3068, 97, 57, 1, 70, "CharacterName",
 CellID->23324],
Cell[3128, 100, 51, 1, 70, "Notes",
 CellID->604282963],
Cell[3182, 103, 47, 1, 70, "Notes",
 CellID->23935],
Cell[3232, 106, 90, 1, 70, "Notes",
 CellID->15580],
Cell[3325, 109, 84, 1, 70, "Notes",
 CellID->25132]
}, Open  ]],
Cell[CellGroupData[{
Cell[3446, 115, 53, 1, 70, "TutorialsSection",
 CellID->11061],
Cell[3502, 118, 196, 4, 70, "Tutorials",
 CellID->23452]
}, Open  ]],
Cell[CellGroupData[{
Cell[3735, 127, 38, 0, 70, "MoreAboutSection"],
Cell[3776, 129, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3956, 136, 50, 1, 70, "SeeAlsoSection",
 CellID->21486],
Cell[4009, 139, 178, 4, 70, "SeeAlso",
 CellID->28717]
}, Open  ]],
Cell[4202, 146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

