(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5910,        202]
NotebookOptionsPosition[      4109,        145]
NotebookOutlinePosition[      5157,        174]
CellTagsIndexPosition[      5114,        171]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Colon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Colon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\\[Colon]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\":\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\":\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->144013165],

Cell["\\[RawColon]", "CharacterName",
 CellID->20505],

Cell["Unicode: 003A.", "Notes",
 CellID->607865850],

Cell["Raw operator. ", "Notes",
 CellID->2337],

Cell["Equivalent to the ordinary ASCII character with code 58. ", "Notes",
 CellID->2778]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->14211],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->22330]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23998],

Cell[TextData[Cell[TextData[ButtonBox["\\[Colon]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/character/Colon"]], "InlineCharacterName"]], "SeeAlso",
 CellID->24668]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawColon] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 43.3914854}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 003A. Raw operator. Equivalent to the ordinary ASCII character \
with code 58. ", "synonyms" -> {"raw colon"}, "title" -> "\\[RawColon]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawColon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1856, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2479, 76, 567, 19, 70, "CharacterImage",
 CellID->144013165],
Cell[3049, 97, 53, 1, 70, "CharacterName",
 CellID->20505],
Cell[3105, 100, 51, 1, 70, "Notes",
 CellID->607865850],
Cell[3159, 103, 46, 1, 70, "Notes",
 CellID->2337],
Cell[3208, 106, 89, 1, 70, "Notes",
 CellID->2778]
}, Open  ]],
Cell[CellGroupData[{
Cell[3334, 112, 53, 1, 70, "TutorialsSection",
 CellID->14211],
Cell[3390, 115, 196, 4, 70, "Tutorials",
 CellID->22330]
}, Open  ]],
Cell[CellGroupData[{
Cell[3623, 124, 38, 0, 70, "MoreAboutSection"],
Cell[3664, 126, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3844, 133, 50, 1, 70, "SeeAlsoSection",
 CellID->23998],
Cell[3897, 136, 170, 4, 70, "SeeAlso",
 CellID->24668]
}, Open  ]],
Cell[4082, 143, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

