(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6910,        235]
NotebookOptionsPosition[      4887,        172]
NotebookOutlinePosition[      6050,        203]
CellTagsIndexPosition[      6007,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CenterDot]" :> 
          Documentation`HelpLookup["paclet:ref/character/CenterDot"], 
          "\\[Ellipsis]" :> 
          Documentation`HelpLookup["paclet:ref/character/Ellipsis"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[CenterDot]\"\>", 
       2->"\<\"\\\\[Ellipsis]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\".\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\".\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->399395381],

Cell["\\[RawDot]", "CharacterName",
 CellID->18534],

Cell["Unicode: 002E.", "Notes",
 CellID->44905317],

Cell["Raw operator. ", "Notes",
 CellID->30851],

Cell["Equivalent to the ordinary ASCII character with code 46. ", "Notes",
 CellID->17629],

Cell["As an overscript, used to indicate time derivative. ", "Notes",
 CellID->17060],

Cell[TextData[{
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "."]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OverDot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverDot"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5501]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->6738],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->11746]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->28081],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CenterDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CenterDot"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Ellipsis]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Ellipsis"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->4949]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawDot] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 50.3135376}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 002E. Raw operator. Equivalent to the ordinary ASCII character \
with code 46. As an overscript, used to indicate time derivative. \
OverscriptBox[StyleBox[x, TI], .] is interpreted as OverDot[x]. ", 
    "synonyms" -> {"raw dot"}, "title" -> "\\[RawDot]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawDot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1996, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2619, 78, 567, 19, 70, "CharacterImage",
 CellID->399395381],
Cell[3189, 99, 51, 1, 70, "CharacterName",
 CellID->18534],
Cell[3243, 102, 50, 1, 70, "Notes",
 CellID->44905317],
Cell[3296, 105, 47, 1, 70, "Notes",
 CellID->30851],
Cell[3346, 108, 90, 1, 70, "Notes",
 CellID->17629],
Cell[3439, 111, 85, 1, 70, "Notes",
 CellID->17060],
Cell[3527, 114, 319, 13, 70, "Notes",
 CellID->5501]
}, Open  ]],
Cell[CellGroupData[{
Cell[3883, 132, 52, 1, 70, "TutorialsSection",
 CellID->6738],
Cell[3938, 135, 196, 4, 70, "Tutorials",
 CellID->11746]
}, Open  ]],
Cell[CellGroupData[{
Cell[4171, 144, 38, 0, 70, "MoreAboutSection"],
Cell[4212, 146, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4392, 153, 50, 1, 70, "SeeAlsoSection",
 CellID->28081],
Cell[4445, 156, 400, 11, 70, "SeeAlso",
 CellID->4949]
}, Open  ]],
Cell[4860, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

