(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6250,        211]
NotebookOptionsPosition[      4454,        154]
NotebookOutlinePosition[      5502,        183]
CellTagsIndexPosition[      5459,        180]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Equal]" :> 
          Documentation`HelpLookup["paclet:ref/character/Equal"], 
          "\\[NotEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotEqual"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[Equal]\"\>", 
       2->"\<\"\\\\[NotEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"=\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"=\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->251898759],

Cell["\\[RawEqual]", "CharacterName",
 CellID->28136],

Cell["Unicode: 003D.", "Notes",
 CellID->90301926],

Cell["Raw operator. ", "Notes",
 CellID->20377],

Cell["Equivalent to the ordinary ASCII character with code 61. ", "Notes",
 CellID->763]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->9938],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->4937]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4864],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Equal]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotEqual"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->478]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 50.6260456}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 003D. Raw operator. Equivalent to the ordinary ASCII character \
with code 61. ", "synonyms" -> {"raw equal"}, "title" -> "\\[RawEqual]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1984, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2607, 78, 567, 19, 70, "CharacterImage",
 CellID->251898759],
Cell[3177, 99, 53, 1, 70, "CharacterName",
 CellID->28136],
Cell[3233, 102, 50, 1, 70, "Notes",
 CellID->90301926],
Cell[3286, 105, 47, 1, 70, "Notes",
 CellID->20377],
Cell[3336, 108, 88, 1, 70, "Notes",
 CellID->763]
}, Open  ]],
Cell[CellGroupData[{
Cell[3461, 114, 52, 1, 70, "TutorialsSection",
 CellID->9938],
Cell[3516, 117, 195, 4, 70, "Tutorials",
 CellID->4937]
}, Open  ]],
Cell[CellGroupData[{
Cell[3748, 126, 38, 0, 70, "MoreAboutSection"],
Cell[3789, 128, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3969, 135, 49, 1, 70, "SeeAlsoSection",
 CellID->4864],
Cell[4021, 138, 391, 11, 70, "SeeAlso",
 CellID->478]
}, Open  ]],
Cell[4427, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

