(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7311,        238]
NotebookOptionsPosition[      5406,        178]
NotebookOutlinePosition[      6506,        208]
CellTagsIndexPosition[      6463,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftDoubleBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftDoubleBracket"], 
          "\\[RawRightBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawRightBracket"], 
          "\\[RightDoubleBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightDoubleBracket"],
           "\\[LeftModified]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftModified"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftDoubleBracket]\"\>",
        2->"\<\"\\\\[RawRightBracket]\"\>", 
       3->"\<\"\\\\[RightDoubleBracket]\"\>", 
       4->"\<\"\\\\[LeftModified]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"[\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"[\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->10695898],

Cell["\\[RawLeftBracket]", "CharacterName",
 CellID->18653],

Cell["Unicode: 005B.", "Notes",
 CellID->19806483],

Cell["Raw operator. ", "Notes",
 CellID->776],

Cell["Equivalent to the ordinary ASCII character with code 91. ", "Notes",
 CellID->24581],

Cell["Extensible character. ", "Notes",
 CellID->14481]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->14036],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->24837]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27593],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftDoubleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftDoubleBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawRightBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawRightBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightDoubleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightDoubleBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftModified"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->5645]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawLeftBracket] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 51.3604394}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 005B. Raw operator. Equivalent to the ordinary ASCII character \
with code 91. Extensible character. ", "synonyms" -> {"raw left bracket"}, 
    "title" -> "\\[RawLeftBracket]", "type" -> "Character Name", "uri" -> 
    "ref/character/RawLeftBracket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2356, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2979, 84, 566, 19, 70, "CharacterImage",
 CellID->10695898],
Cell[3548, 105, 59, 1, 70, "CharacterName",
 CellID->18653],
Cell[3610, 108, 50, 1, 70, "Notes",
 CellID->19806483],
Cell[3663, 111, 45, 1, 70, "Notes",
 CellID->776],
Cell[3711, 114, 90, 1, 70, "Notes",
 CellID->24581],
Cell[3804, 117, 55, 1, 70, "Notes",
 CellID->14481]
}, Open  ]],
Cell[CellGroupData[{
Cell[3896, 123, 53, 1, 70, "TutorialsSection",
 CellID->14036],
Cell[3952, 126, 196, 4, 70, "Tutorials",
 CellID->24837]
}, Open  ]],
Cell[CellGroupData[{
Cell[4185, 135, 38, 0, 70, "MoreAboutSection"],
Cell[4226, 137, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4406, 144, 50, 1, 70, "SeeAlsoSection",
 CellID->27593],
Cell[4459, 147, 905, 26, 70, "SeeAlso",
 CellID->5645]
}, Open  ]],
Cell[5379, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

