(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6642,        226]
NotebookOptionsPosition[      4749,        166]
NotebookOutlinePosition[      5836,        196]
CellTagsIndexPosition[      5793,        193]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotLess]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotLess"], 
          "\\[LeftAngleBracket]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/LeftAngleBracket"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[NotLess]\"\>", 
       2->"\<\"\\\\[LeftAngleBracket]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"<\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"<\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->36104664],

Cell["\\[RawLess]", "CharacterName",
 CellID->7061],

Cell["Unicode: 003C.", "Notes",
 CellID->71061004],

Cell["Raw operator. ", "Notes",
 CellID->18835],

Cell["Equivalent to the ordinary ASCII character with code 60. ", "Notes",
 CellID->21833],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[LeftAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftAngleBracket"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->21014]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->595],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->10848]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->26487],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotLess"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftAngleBracket"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->21164]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawLess] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 58.1731138}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 003C. Raw operator. Equivalent to the ordinary ASCII character \
with code 60. Not the same as \\[LeftAngleBracket]. ", 
    "synonyms" -> {"raw less"}, "title" -> "\\[RawLess]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawLess"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2026, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2649, 79, 566, 19, 70, "CharacterImage",
 CellID->36104664],
Cell[3218, 100, 51, 1, 70, "CharacterName",
 CellID->7061],
Cell[3272, 103, 50, 1, 70, "Notes",
 CellID->71061004],
Cell[3325, 106, 47, 1, 70, "Notes",
 CellID->18835],
Cell[3375, 109, 90, 1, 70, "Notes",
 CellID->21833],
Cell[3468, 112, 225, 8, 70, "Notes",
 CellID->21014]
}, Open  ]],
Cell[CellGroupData[{
Cell[3730, 125, 51, 1, 70, "TutorialsSection",
 CellID->595],
Cell[3784, 128, 196, 4, 70, "Tutorials",
 CellID->10848]
}, Open  ]],
Cell[CellGroupData[{
Cell[4017, 137, 38, 0, 70, "MoreAboutSection"],
Cell[4058, 139, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4238, 146, 50, 1, 70, "SeeAlsoSection",
 CellID->26487],
Cell[4291, 149, 416, 12, 70, "SeeAlso",
 CellID->21164]
}, Open  ]],
Cell[4722, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

