(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6835,        235]
NotebookOptionsPosition[      4854,        173]
NotebookOutlinePosition[      5972,        203]
CellTagsIndexPosition[      5929,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ReturnIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnIndicator"], 
          "\\[NewLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/NewLine"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[ReturnIndicator]\"\>", 
       2->"\<\"\\\\[NewLine]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"
\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"
\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->128333414],

Cell["\\[RawReturn]", "CharacterName",
 CellID->21628],

Cell["Unicode: 000D.", "Notes",
 CellID->9515055],

Cell["Spacing character. ", "Notes",
 CellID->16106],

Cell["Equivalent to the ordinary ASCII character with code 13. ", "Notes",
 CellID->28455],

Cell[TextData[{
 "Can be entered as \[Backslash]",
 Cell[BoxData["r"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17254],

Cell[TextData[{
 "Not always the same as ",
 Cell[TextData[ButtonBox["\\[NewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->11251]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->17887],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->13077]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22536],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ReturnIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->27340]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawReturn] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 59.1262632}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 000D. Spacing character. Equivalent to the ordinary ASCII \
character with code 13. Can be entered as \\r. Not always the same as \
\\[NewLine]. ", "synonyms" -> {"raw return"}, "title" -> "\\[RawReturn]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawReturn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2011, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2634, 78, 567, 21, 70, "CharacterImage",
 CellID->128333414],
Cell[3204, 101, 54, 1, 70, "CharacterName",
 CellID->21628],
Cell[3261, 104, 49, 1, 70, "Notes",
 CellID->9515055],
Cell[3313, 107, 52, 1, 70, "Notes",
 CellID->16106],
Cell[3368, 110, 90, 1, 70, "Notes",
 CellID->28455],
Cell[3461, 113, 123, 5, 70, "Notes",
 CellID->17254],
Cell[3587, 120, 211, 7, 70, "Notes",
 CellID->11251]
}, Open  ]],
Cell[CellGroupData[{
Cell[3835, 132, 53, 1, 70, "TutorialsSection",
 CellID->17887],
Cell[3891, 135, 196, 4, 70, "Tutorials",
 CellID->13077]
}, Open  ]],
Cell[CellGroupData[{
Cell[4124, 144, 38, 0, 70, "MoreAboutSection"],
Cell[4165, 146, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4345, 153, 50, 1, 70, "SeeAlsoSection",
 CellID->22536],
Cell[4398, 156, 414, 12, 70, "SeeAlso",
 CellID->27340]
}, Open  ]],
Cell[4827, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

