(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7630,        249]
NotebookOptionsPosition[      5629,        187]
NotebookOutlinePosition[      6768,        217]
CellTagsIndexPosition[      6725,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftDoubleBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftDoubleBracket"], 
          "\\[RawLeftBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawLeftBracket"], 
          "\\[RightDoubleBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightDoubleBracket"],
           "\\[RightModified]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightModified"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftDoubleBracket]\"\>",
        2->"\<\"\\\\[RawLeftBracket]\"\>", 
       3->"\<\"\\\\[RightDoubleBracket]\"\>", 
       4->"\<\"\\\\[RightModified]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->231833680],

Cell["\\[RawRightBracket]", "CharacterName",
 CellID->21003],

Cell["Unicode: 005D.", "Notes",
 CellID->758092923],

Cell["Raw operator. ", "Notes",
 CellID->11266],

Cell["Equivalent to the ordinary ASCII character with code 93. ", "Notes",
 CellID->20268],

Cell["Extensible character. ", "Notes",
 CellID->21924],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RightModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightModified"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->9673]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->12385],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->28274]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22329],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftDoubleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftDoubleBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawLeftBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawLeftBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightDoubleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightDoubleBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightModified"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->1826]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawRightBracket] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 59.3762696}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 005D. Raw operator. Equivalent to the ordinary ASCII character \
with code 93. Extensible character. Not the same as \\[RightModified]. ", 
    "synonyms" -> {"raw right bracket"}, "title" -> "\\[RawRightBracket]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawRightBracket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2356, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2979, 84, 567, 19, 70, "CharacterImage",
 CellID->231833680],
Cell[3549, 105, 60, 1, 70, "CharacterName",
 CellID->21003],
Cell[3612, 108, 51, 1, 70, "Notes",
 CellID->758092923],
Cell[3666, 111, 47, 1, 70, "Notes",
 CellID->11266],
Cell[3716, 114, 90, 1, 70, "Notes",
 CellID->20268],
Cell[3809, 117, 55, 1, 70, "Notes",
 CellID->21924],
Cell[3867, 120, 215, 7, 70, "Notes",
 CellID->9673]
}, Open  ]],
Cell[CellGroupData[{
Cell[4119, 132, 53, 1, 70, "TutorialsSection",
 CellID->12385],
Cell[4175, 135, 196, 4, 70, "Tutorials",
 CellID->28274]
}, Open  ]],
Cell[CellGroupData[{
Cell[4408, 144, 38, 0, 70, "MoreAboutSection"],
Cell[4449, 146, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4629, 153, 50, 1, 70, "SeeAlsoSection",
 CellID->22329],
Cell[4682, 156, 905, 26, 70, "SeeAlso",
 CellID->1826]
}, Open  ]],
Cell[5602, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

