(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7558,        254]
NotebookOptionsPosition[      5475,        190]
NotebookOutlinePosition[      6695,        222]
CellTagsIndexPosition[      6652,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Star]" :> 
          Documentation`HelpLookup["paclet:ref/character/Star"], "\\[Times]" :> 
          Documentation`HelpLookup["paclet:ref/character/Times"], 
          "\\[SixPointedStar]" :> 
          Documentation`HelpLookup["paclet:ref/character/SixPointedStar"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Star]\"\>", 
       2->"\<\"\\\\[Times]\"\>", 
       3->"\<\"\\\\[SixPointedStar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"*\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"*\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->872448548],

Cell["\\[RawStar]", "CharacterName",
 CellID->21514],

Cell["Unicode: 002A.", "Notes",
 CellID->157451973],

Cell["Raw operator. ", "Notes",
 CellID->1065],

Cell["Equivalent to the ordinary ASCII character with code 42. ", "Notes",
 CellID->29328],

Cell[TextData[{
 "In addition to one\[Hyphen]dimensional uses, ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["x", "TI"], "*"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperStar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15798],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["x", "TI"], "*"]], "InlineMath"],
 " is often used in mathematics to indicate a conjugate, dual, or completion \
of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13671]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11864],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->8490]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4219],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Star]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Star"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SixPointedStar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SixPointedStar"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->6347]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawStar] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 6.6108298}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 002A. Raw operator. Equivalent to the ordinary ASCII character \
with code 42. In addition to one-dimensional uses, x^* is by default \
interpreted as SuperStar[x]. x^* is often used in mathematics to indicate a \
conjugate, dual, or completion of x. ", "synonyms" -> {"raw star"}, "title" -> 
    "\\[RawStar]", "type" -> "Character Name", "uri" -> 
    "ref/character/RawStar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2116, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2739, 80, 567, 19, 70, "CharacterImage",
 CellID->872448548],
Cell[3309, 101, 52, 1, 70, "CharacterName",
 CellID->21514],
Cell[3364, 104, 51, 1, 70, "Notes",
 CellID->157451973],
Cell[3418, 107, 46, 1, 70, "Notes",
 CellID->1065],
Cell[3467, 110, 90, 1, 70, "Notes",
 CellID->29328],
Cell[3560, 113, 386, 14, 70, "Notes",
 CellID->15798],
Cell[3949, 129, 271, 10, 70, "Notes",
 CellID->13671]
}, Open  ]],
Cell[CellGroupData[{
Cell[4257, 144, 53, 1, 70, "TutorialsSection",
 CellID->11864],
Cell[4313, 147, 195, 4, 70, "Tutorials",
 CellID->8490]
}, Open  ]],
Cell[CellGroupData[{
Cell[4545, 156, 38, 0, 70, "MoreAboutSection"],
Cell[4586, 158, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4766, 165, 49, 1, 70, "SeeAlsoSection",
 CellID->4219],
Cell[4818, 168, 615, 17, 70, "SeeAlso",
 CellID->6347]
}, Open  ]],
Cell[5448, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

