(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6176,        212]
NotebookOptionsPosition[      4289,        152]
NotebookOutlinePosition[      5371,        182]
CellTagsIndexPosition[      5328,        179]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightArrowBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrowBar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[RightArrowBar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\t\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\t\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->254800125],

Cell["\\[RawTab]", "CharacterName",
 CellID->2518],

Cell["Unicode: 0009.", "Notes",
 CellID->13389070],

Cell["Spacing character. ", "Notes",
 CellID->1403],

Cell["Equivalent to the ordinary ASCII character with code 9. ", "Notes",
 CellID->4031],

Cell[TextData[{
 "Can be entered in strings as \[Backslash]",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26861]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->14565],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->11303]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->30160],

Cell[TextData[Cell[TextData[ButtonBox["\\[RightArrowBar]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/character/RightArrowBar"]], "InlineCharacterName"]], "SeeAlso",
 CellID->20184]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawTab] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 6.7670838}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0009. Spacing character. Equivalent to the ordinary ASCII \
character with code 9. Can be entered in strings as \\t. ", 
    "synonyms" -> {"raw tab"}, "title" -> "\\[RawTab]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawTab"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1881, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2504, 76, 569, 19, 70, "CharacterImage",
 CellID->254800125],
Cell[3076, 97, 50, 1, 70, "CharacterName",
 CellID->2518],
Cell[3129, 100, 50, 1, 70, "Notes",
 CellID->13389070],
Cell[3182, 103, 51, 1, 70, "Notes",
 CellID->1403],
Cell[3236, 106, 88, 1, 70, "Notes",
 CellID->4031],
Cell[3327, 109, 134, 5, 70, "Notes",
 CellID->26861]
}, Open  ]],
Cell[CellGroupData[{
Cell[3498, 119, 53, 1, 70, "TutorialsSection",
 CellID->14565],
Cell[3554, 122, 196, 4, 70, "Tutorials",
 CellID->11303]
}, Open  ]],
Cell[CellGroupData[{
Cell[3787, 131, 38, 0, 70, "MoreAboutSection"],
Cell[3828, 133, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4008, 140, 50, 1, 70, "SeeAlsoSection",
 CellID->30160],
Cell[4061, 143, 186, 4, 70, "SeeAlso",
 CellID->20184]
}, Open  ]],
Cell[4262, 150, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

