(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6825,        231]
NotebookOptionsPosition[      4848,        170]
NotebookOutlinePosition[      6017,        201]
CellTagsIndexPosition[      5974,        198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Tilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/Tilde"], 
          "\\[NotTilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotTilde"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[Tilde]\"\>", 
       2->"\<\"\\\\[NotTilde]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"~\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"~\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->194040137],

Cell["\\[RawTilde]", "CharacterName",
 CellID->23926],

Cell["Unicode: 007E.", "Notes",
 CellID->13111096],

Cell["Raw operator. ", "Notes",
 CellID->13845],

Cell["Equivalent to the ordinary ASCII character with code 126. ", "Notes",
 CellID->14587],

Cell[TextData[{
 "In addition to one\[Hyphen]dimensional uses, ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "~"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OverTilde",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverTilde"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1562]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->14524],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->16519]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4184],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Tilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Tilde"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotTilde"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->12943]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawTilde] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 6.9233378}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 007E. Raw operator. Equivalent to the ordinary ASCII character \
with code 126. In addition to one-dimensional uses, OverscriptBox[StyleBox[x, \
TI], ~] is by default interpreted as OverTilde[x]. ", 
    "synonyms" -> {"raw tilde"}, "title" -> "\\[RawTilde]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawTilde"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1984, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2607, 78, 567, 19, 70, "CharacterImage",
 CellID->194040137],
Cell[3177, 99, 53, 1, 70, "CharacterName",
 CellID->23926],
Cell[3233, 102, 50, 1, 70, "Notes",
 CellID->13111096],
Cell[3286, 105, 47, 1, 70, "Notes",
 CellID->13845],
Cell[3336, 108, 91, 1, 70, "Notes",
 CellID->14587],
Cell[3430, 111, 384, 14, 70, "Notes",
 CellID->1562]
}, Open  ]],
Cell[CellGroupData[{
Cell[3851, 130, 53, 1, 70, "TutorialsSection",
 CellID->14524],
Cell[3907, 133, 196, 4, 70, "Tutorials",
 CellID->16519]
}, Open  ]],
Cell[CellGroupData[{
Cell[4140, 142, 38, 0, 70, "MoreAboutSection"],
Cell[4181, 144, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4361, 151, 49, 1, 70, "SeeAlsoSection",
 CellID->4184],
Cell[4413, 154, 393, 11, 70, "SeeAlso",
 CellID->12943]
}, Open  ]],
Cell[4821, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

