(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6822,        238]
NotebookOptionsPosition[      4756,        175]
NotebookOutlinePosition[      5960,        206]
CellTagsIndexPosition[      5917,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Dash]" :> 
          Documentation`HelpLookup["paclet:ref/character/Dash"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\\[Dash]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"_\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"_\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->160364092],

Cell["\\[RawUnderscore]", "CharacterName",
 CellID->9624],

Cell["Unicode: 005F.", "Notes",
 CellID->681151688],

Cell["Raw operator. ", "Notes",
 CellID->18886],

Cell["Equivalent to the ordinary ASCII character with code 95. ", "Notes",
 CellID->2353],

Cell[TextData[{
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "_"]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OverBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverBar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15767],

Cell[TextData[{
 Cell[BoxData[
  UnderscriptBox[
   StyleBox["x", "TI"], "_"]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderBar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15332]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21556],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->24719]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4694],

Cell[TextData[Cell[TextData[ButtonBox["\\[Dash]",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/character/Dash"]], "InlineCharacterName"]], "SeeAlso",\

 CellID->12703]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawUnderscore] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 7.0952172}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 005F. Raw operator. Equivalent to the ordinary ASCII character \
with code 95. OverscriptBox[StyleBox[x, TI], _] is interpreted as OverBar[x]. \
UnderscriptBox[StyleBox[x, TI], _] is interpreted as UnderBar[x]. ", 
    "synonyms" -> {"raw underscore"}, "title" -> "\\[RawUnderscore]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawUnderscore"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1853, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2476, 76, 567, 19, 70, "CharacterImage",
 CellID->160364092],
Cell[3046, 97, 57, 1, 70, "CharacterName",
 CellID->9624],
Cell[3106, 100, 51, 1, 70, "Notes",
 CellID->681151688],
Cell[3160, 103, 47, 1, 70, "Notes",
 CellID->18886],
Cell[3210, 106, 89, 1, 70, "Notes",
 CellID->2353],
Cell[3302, 109, 320, 13, 70, "Notes",
 CellID->15767],
Cell[3625, 124, 323, 13, 70, "Notes",
 CellID->15332]
}, Open  ]],
Cell[CellGroupData[{
Cell[3985, 142, 53, 1, 70, "TutorialsSection",
 CellID->21556],
Cell[4041, 145, 196, 4, 70, "Tutorials",
 CellID->24719]
}, Open  ]],
Cell[CellGroupData[{
Cell[4274, 154, 38, 0, 70, "MoreAboutSection"],
Cell[4315, 156, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4495, 163, 49, 1, 70, "SeeAlsoSection",
 CellID->4694],
Cell[4547, 166, 167, 4, 70, "SeeAlso",
 CellID->12703]
}, Open  ]],
Cell[4729, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

