(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6515,        219]
NotebookOptionsPosition[      4611,        159]
NotebookOutlinePosition[      5711,        189]
CellTagsIndexPosition[      5668,        186]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[VerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalBar"], 
          "\\[LeftBracketingBar]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/LeftBracketingBar"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[VerticalBar]\"\>", 
       2->"\<\"\\\\[LeftBracketingBar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"|\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"|\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->756877519],

Cell["\\[RawVerticalBar]", "CharacterName",
 CellID->1666],

Cell["Unicode: 007C.", "Notes",
 CellID->87868779],

Cell["Raw operator. ", "Notes",
 CellID->9259],

Cell["Equivalent to the ordinary ASCII character with code 124. ", "Notes",
 CellID->17419],

Cell["Extensible character. ", "Notes",
 CellID->17509]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->276],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->14528]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->8342],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->20344]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawVerticalBar] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 7.2514712}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 007C. Raw operator. Equivalent to the ordinary ASCII character \
with code 124. Extensible character. ", "synonyms" -> {"raw vertical bar"}, 
    "title" -> "\\[RawVerticalBar]", "type" -> "Character Name", "uri" -> 
    "ref/character/RawVerticalBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 79, 567, 19, 70, "CharacterImage",
 CellID->756877519],
Cell[3234, 100, 58, 1, 70, "CharacterName",
 CellID->1666],
Cell[3295, 103, 50, 1, 70, "Notes",
 CellID->87868779],
Cell[3348, 106, 46, 1, 70, "Notes",
 CellID->9259],
Cell[3397, 109, 91, 1, 70, "Notes",
 CellID->17419],
Cell[3491, 112, 55, 1, 70, "Notes",
 CellID->17509]
}, Open  ]],
Cell[CellGroupData[{
Cell[3583, 118, 51, 1, 70, "TutorialsSection",
 CellID->276],
Cell[3637, 121, 196, 4, 70, "Tutorials",
 CellID->14528]
}, Open  ]],
Cell[CellGroupData[{
Cell[3870, 130, 38, 0, 70, "MoreAboutSection"],
Cell[3911, 132, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4091, 139, 49, 1, 70, "SeeAlsoSection",
 CellID->8342],
Cell[4143, 142, 426, 12, 70, "SeeAlso",
 CellID->20344]
}, Open  ]],
Cell[4584, 157, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

