(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8807,        281]
NotebookOptionsPosition[      6769,        217]
NotebookOutlinePosition[      7928,        248]
CellTagsIndexPosition[      7885,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ReturnKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnKey"], 
          "\\[EnterKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/EnterKey"], 
          "\\[Continuation]" :> 
          Documentation`HelpLookup["paclet:ref/character/Continuation"], 
          "\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"], 
          "\\[SpaceIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SpaceIndicator"], 
          "\\[NonBreakingSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NonBreakingSpace"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[ReturnKey]\"\>", 
       2->"\<\"\\\\[EnterKey]\"\>", 3->"\<\"\\\\[Continuation]\"\>", 
       4->"\<\"\\\\[ControlKey]\"\>", 5->"\<\"\\\\[CommandKey]\"\>", 
       6->"\<\"\\\\[SpaceIndicator]\"\>", 
       7->"\<\"\\\\[NonBreakingSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ReturnIndicator]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ReturnIndicator]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->300059575],

Cell["\\[ReturnIndicator]", "CharacterName",
 CellID->1912],

Cell["Unicode: 21B5.", "Notes",
 CellID->31686],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ret", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->24145],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->15870],

Cell["\<\
Representation of the return or newline character on a keyboard. \
\>", "Notes",
 CellID->30713],

Cell["Used in showing how textual input is typed. ", "Notes",
 CellID->12848]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->12679],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->13886]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1914],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ReturnKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EnterKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EnterKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Continuation]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Continuation"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NonBreakingSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NonBreakingSpace"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->8765]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->863594016],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ReturnIndicator] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 14.1578980}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 21B5. Alias: Esc ret Esc. Letter-like form. Representation of \
the return or newline character on a keyboard. Used in showing how textual \
input is typed. ", "synonyms" -> {"return indicator"}, "title" -> 
    "\\[ReturnIndicator]", "type" -> "Character Name", "uri" -> 
    "ref/character/ReturnIndicator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2738, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3361, 92, 601, 19, 70, "CharacterImage",
 CellID->300059575],
Cell[3965, 113, 59, 1, 70, "CharacterName",
 CellID->1912],
Cell[4027, 116, 47, 1, 70, "Notes",
 CellID->31686],
Cell[4077, 119, 235, 9, 70, "Notes",
 CellID->24145],
Cell[4315, 130, 59, 1, 70, "Notes",
 CellID->15870],
Cell[4377, 133, 106, 3, 70, "Notes",
 CellID->30713],
Cell[4486, 138, 77, 1, 70, "Notes",
 CellID->12848]
}, Open  ]],
Cell[CellGroupData[{
Cell[4600, 144, 53, 1, 70, "TutorialsSection",
 CellID->12679],
Cell[4656, 147, 196, 4, 70, "Tutorials",
 CellID->13886]
}, Open  ]],
Cell[CellGroupData[{
Cell[4889, 156, 49, 1, 70, "SeeAlsoSection",
 CellID->1914],
Cell[4941, 159, 1545, 43, 70, "SeeAlso",
 CellID->8765]
}, Open  ]],
Cell[CellGroupData[{
Cell[6523, 207, 58, 1, 70, "MoreAboutSection",
 CellID->863594016],
Cell[6584, 210, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6742, 215, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

